# 🎯 AfrexAI Project Manager

Complete project delivery system for AI agents. Plan, track, and deliver projects on time using proven PM frameworks — no tools required.

## Install

```bash
clawhub install afrexai-project-manager
```

## What You Get

- **Project intake & scoping** — YAML templates for charter, stakeholders, RACI
- **Work Breakdown Structure** — 3-level hierarchy with 8/80 rule, dependencies
- **Three-point estimation** — no more guessing, includes buffer checklist
- **Critical path & scheduling** — milestones, float analysis, compression techniques
- **Risk management** — register, scoring matrix, top 10 universal risks pre-written
- **Status reporting** — weekly template with health scoring (0-100)
- **Agile ceremonies** — sprint planning, standups, retros, change control
- **Project closure** — checklist + lessons learned framework

## Quick Start

Tell your agent: *"New project: migrate our payment system to Stripe by March 15"*

It will run the full intake, build a WBS, identify risks, and set up tracking.

## Who This Is For

- Startup founders managing builds
- Freelancers juggling client projects
- Team leads who need structure without heavy tools
- Anyone shipping something with a deadline

## ⚡ Level Up

Want industry-specific project templates with pricing frameworks, compliance checklists, and delivery playbooks?

**[SaaS Context Pack — $47](https://afrexai-cto.github.io/context-packs/)** — includes SaaS product launch, sprint management, and go-to-market templates.

**[Professional Services Pack — $47](https://afrexai-cto.github.io/context-packs/)** — client delivery frameworks, SOW templates, and engagement management.

## 🔗 More Free Skills by AfrexAI

- `afrexai-lead-hunter` — Find and qualify leads with scoring rubrics
- `afrexai-seo-content-engine` — SEO-optimized content creation framework
- `afrexai-business-automation` — Automate workflows end-to-end
- `afrexai-code-reviewer` — 60+ pattern code review with SPEAR framework
- `afrexai-customer-support` — Support operations with churn risk scoring

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
