# Profit Margin Analyzer

Analyze and optimize profit margins across your business. Identifies margin compression, pricing opportunities, and cost levers.

## What This Does
- Calculates gross, operating, and net margins by product/service line
- Benchmarks against industry standards (2026 data)
- Identifies margin erosion patterns and root causes
- Generates pricing adjustment recommendations
- Models impact of cost changes on profitability

## How to Use

Tell your agent:
- "Analyze our profit margins" — gets full breakdown with benchmarks
- "Where are we losing margin?" — identifies compression points
- "Model a 5% price increase" — shows bottom-line impact

## Margin Framework

### Gross Margin Benchmarks (2026)
| Industry | Healthy | Warning | Critical |
|----------|---------|---------|----------|
| SaaS | >70% | 55-70% | <55% |
| Professional Services | >35% | 25-35% | <25% |
| Manufacturing | >25% | 15-25% | <15% |
| Ecommerce | >40% | 25-40% | <25% |
| Construction | >20% | 12-20% | <12% |
| Healthcare Services | >45% | 30-45% | <30% |
| Legal Services | >40% | 30-40% | <30% |
| Real Estate (Brokerage) | >30% | 20-30% | <20% |
| Recruitment/Staffing | >25% | 15-25% | <15% |
| Financial Services | >50% | 35-50% | <35% |

### The 1% Pricing Rule
A 1% price increase on a 10% net margin business = **12.5% profit increase**.
This is the single highest-leverage move most businesses ignore.

### Margin Erosion Checklist
1. **Scope creep** — delivering more than contracted (services firms lose 8-15% here)
2. **Discount culture** — average B2B discount is 22%, top performers keep it under 12%
3. **Underpriced legacy contracts** — review any deal older than 18 months
4. **Hidden delivery costs** — support, onboarding, custom work not in COGS
5. **Volume without leverage** — more revenue at same margins ≠ more profit if fixed costs grew
6. **Currency exposure** — international revenue without hedging
7. **Vendor cost inflation** — AWS/Azure/GCP bills creep 15-20% annually without optimization

### Pricing Power Assessment
Rate each factor 1-5:
- **Switching costs** — how painful is it for customers to leave?
- **Differentiation** — can customers get this elsewhere easily?
- **Value visibility** — do customers see/measure the value you deliver?
- **Competitive density** — how many alternatives exist?
- **Customer concentration** — does one client control >20% of revenue?

Score 20+: Strong pricing power. Raise prices 5-10% annually.
Score 15-19: Moderate. Raise selectively on new deals.
Score <15: Weak. Focus on differentiation before pricing.

### Cost Structure Analysis

#### Fixed vs Variable Ratio
| Business Type | Target Fixed % | Target Variable % |
|---------------|---------------|-------------------|
| SaaS | 70-80% | 20-30% |
| Services | 40-50% | 50-60% |
| Manufacturing | 30-40% | 60-70% |
| Marketplace | 60-70% | 30-40% |

High fixed cost = operational leverage (margins expand with scale).
High variable cost = flexibility (margins stable but limited upside).

### Contribution Margin by Product Line
For each product/service:
```
Revenue: $___
- Direct costs (COGS): $___
- Variable selling costs: $___
= Contribution margin: $___
Contribution margin %: ___%
```

Kill anything below 20% contribution margin unless it's a strategic loss leader with proven upsell path.

### Quick Wins (30-Day Margin Improvement)
1. Audit discounting — cap at 15%, require VP approval above 10%
2. Review tool/SaaS spend — cancel unused licenses (avg company wastes 25%)
3. Renegotiate top 3 vendor contracts — 5-15% savings typical at renewal
4. Implement value-based pricing on at least one product line
5. Add a premium tier — 10-20% of customers will upgrade

### 90-Day Margin Optimization Roadmap
**Month 1:** Audit — map all revenue streams, costs, margins by line
**Month 2:** Price — implement increases on weakest-margin products
**Month 3:** Cut — eliminate sub-20% contribution margin lines, renegotiate vendors

### Annual Margin Health Check
Run quarterly:
- [ ] Gross margin trend (3-quarter rolling)
- [ ] Net margin vs industry benchmark
- [ ] Customer acquisition cost payback period
- [ ] Revenue per employee trend
- [ ] Pricing power score reassessment

---

## More Resources

- **AI Revenue Leak Calculator** — Find where your business is bleeding money: https://afrexai-cto.github.io/ai-revenue-calculator/
- **Industry Context Packs** ($47 each) — Deep frameworks for your specific industry: https://afrexai-cto.github.io/context-packs/
- **Agent Setup Wizard** — Configure AI agents for your business in minutes: https://afrexai-cto.github.io/agent-setup/

### Bundle Deals
- 📘 AI Automation Playbook — $27
- 🎯 Pick Any 3 Packs — $97 (save $44)
- 📦 All 10 Industry Packs — $197 (save $273)
- 🏆 Everything Bundle — $247 (all packs + playbook + setup wizard)
