# Productivity Operating System ⚡

**Stop managing tasks. Start engineering output.**

Most productivity skills give you a to-do list. This gives you a complete operating system — energy mapping, time architecture, focus engineering, burnout prevention, and weekly scoring.

## Install

```bash
clawhub install afrexai-productivity-system
```

## What You Get

- **Energy Audit** — Map your chronotype, peak hours, and energy drains
- **1-3-5 Priority Framework** — Never wonder "what should I work on?" again
- **Time Block Templates** — Ready-to-use daily schedules matched to your energy
- **90-Minute Deep Work Cycles** — Flow state engineering with distraction capture
- **Weekly Planning + Review** — 30-min Sunday sessions that 10X your week
- **Burnout Early Warning** — 8-signal scoring system before it's too late
- **Productivity Scoring** — Daily 0-100 score across execution, energy, and discipline
- **Procrastination Diagnostic** — Identify exactly why you're stuck and fix it
- **Decision Fatigue Prevention** — Pre-decide everything that doesn't matter
- **ADHD / WFH / Multi-Project Adaptations** — Edge cases covered

## Quick Start

Tell your agent: **"Set up my productivity system"** — it'll interview you about your energy patterns and build a personalized daily template.

Or jump straight in:
- **"Plan my day"** — Get a prioritized, time-blocked schedule
- **"I can't focus"** — Diagnose and fix what's blocking you
- **"Am I burning out?"** — 8-signal assessment with action plan
- **"Review my week"** — Structured weekly retrospective

## ⚡ Level Up

Want to apply this productivity system to an entire team or business?

**[AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47 industry-specific agent configurations with built-in productivity frameworks for SaaS, Professional Services, and more.

## 🔗 More Free Skills by AfrexAI

- [afrexai-meeting-mastery](https://clawhub.com/skills/afrexai-meeting-mastery) — Meeting prep, agendas, follow-ups
- [afrexai-decision-engine](https://clawhub.com/skills/afrexai-decision-engine) — 8 decision frameworks
- [afrexai-okr-engine](https://clawhub.com/skills/afrexai-okr-engine) — OKR system with scoring
- [afrexai-project-manager](https://clawhub.com/skills/afrexai-project-manager) — Full PM delivery system
- [afrexai-founder-os](https://clawhub.com/skills/afrexai-founder-os) — Startup operating system

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
