# 🎯 Product Management OS — by AfrexAI

The most comprehensive product management skill on ClawHub. Complete system for discovery, prioritization, roadmapping, metrics, and cross-functional leadership.

## What This Does

Turns your AI agent into a world-class product management partner:

- **Strategy briefs** — Vision, positioning, competitive landscape, anti-goals
- **User research** — Interview scripts, synthesis templates, pattern recognition
- **Prioritization** — RICE+ framework with strategic alignment scoring
- **Roadmapping** — Now/Next/Later with confidence levels and outcome focus
- **Specifications** — One-pagers, user stories with acceptance criteria, quality scoring
- **Metrics** — North star framework, cohort analysis, review cadence
- **Stakeholder management** — Mapping, communication plans, update templates
- **Product-led growth** — Activation framework, viral loops, pricing principles
- **Cross-functional playbooks** — Working with eng, design, sales, CS
- **Advanced patterns** — Platform PM, multi-product, AI/ML features, rescue playbook

## Install

```bash
clawhub install afrexai-product-manager
```

## Quick Start

```
"Help me create a product strategy for our new feature"
"/pm health" — Score your current PM practice
"/pm discovery" — Build an interview script
"/pm prioritize" — Score features with RICE+
"/pm roadmap" — Create a Now/Next/Later roadmap
```

## What Makes This Different

- **26KB of methodology** vs competitors' 3KB advice lists
- **12 complete phases** covering the full PM lifecycle
- **YAML templates** for every artifact (strategy, discovery, specs, metrics)
- **100-point quality rubric** across 8 weighted dimensions
- **Benchmarks** for SaaS, marketplace, e-commerce, and more
- **12 natural language commands** for instant access
- Zero dependencies — works with any AI agent framework

## ⚡ Level Up

Want industry-specific product strategies with market data, competitor analysis, and pricing frameworks?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)**

- 🖥️ SaaS Operations Pack — SaaS-specific PM playbooks
- 💼 Professional Services Pack — Services product management
- 🏥 Healthcare AI Pack — Regulated product development
- 💰 Fintech Pack — Financial product compliance

## 🔗 More Free Skills by AfrexAI

- [afrexai-prd-engine](https://clawhub.com/skills/afrexai-prd-engine) — PRD writing system
- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — B2B sales methodology
- [afrexai-customer-success](https://clawhub.com/skills/afrexai-customer-success) — Retention & expansion
- [afrexai-competitive-intel](https://clawhub.com/skills/afrexai-competitive-intel) — Competitive intelligence
- [afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy) — Brand & GTM system

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
