# Product Launch Playbook 🚀

The complete product launch system — from pre-launch validation through post-launch growth. Works for SaaS, physical products, services, marketplaces, and content products.

## What You Get

- **6-phase launch framework** covering readiness → strategy → pre-launch → execution → growth → retrospective
- **Launch readiness scorecard** with kill criteria (don't launch until you're ready)
- **4 launch type templates** (SaaS, B2B service, content/course, feature drop)
- **Hour-by-hour launch day playbook** with war room protocol
- **Pre-launch content calendar** (8-week plan)
- **Post-launch funnel analysis** with benchmarks at every stage
- **Product Hunt & Hacker News** launch optimization guides
- **Viral loop design** framework with K-factor calculation
- **Pricing launch strategies** (founding price, early bird, freemium, beta-to-GA)
- **Edge cases**: crowded markets, zero audience, failed launch recovery, international

## Install

```bash
clawhub install afrexai-product-launch
```

## Quick Start

Just tell your agent:
- "Assess my launch readiness" — get scored across 6 dimensions
- "Plan my SaaS launch" — full timeline + checklist
- "Build my launch day schedule" — hour-by-hour playbook
- "Run my 30-day retrospective" — learn from what happened

## ⚡ Level Up

This free skill covers the launch framework. For complete industry-specific context (competitive landscape, buyer personas, regulatory requirements, pricing benchmarks):

**[AfrexAI Context Packs — $47 each](https://afrexai-cto.github.io/context-packs/)**

Available for: SaaS, Fintech, Healthcare, Legal, Construction, Ecommerce, Real Estate, Recruitment, Manufacturing, Professional Services.

## 🔗 More Free Skills by AfrexAI

- [afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy) — Brand positioning & GTM
- [afrexai-prd-engine](https://clawhub.com/skills/afrexai-prd-engine) — Product requirements docs
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Get pricing right
- [afrexai-email-marketing-engine](https://clawhub.com/skills/afrexai-email-marketing-engine) — Launch email sequences
- [afrexai-competitive-intel](https://clawhub.com/skills/afrexai-competitive-intel) — Know your market

**Browse all AfrexAI skills → [clawhub.com](https://clawhub.com)**

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
