# Procurement Manager

AI-powered procurement agent for purchase orders, vendor evaluation, spend analysis, and contract negotiation.

## What It Does

- **Purchase Orders** — Generate structured POs with approval routing based on spend tiers
- **Vendor Scoring** — 7-dimension weighted scorecard (price, quality, reliability, terms, support, scalability, risk)
- **Spend Analysis** — Category breakdowns, maverick spend detection, contract renewal alerts
- **Negotiation Prep** — Market benchmarks, leverage points, counter-offer drafts, BATNA definition

## Why This Matters

Companies waste 15-20% of procurement spend through poor vendor management, off-contract purchases, and missed negotiation opportunities. This skill gives your agent the framework to catch those leaks.

## Quick Start

Install and ask your agent:
- "Create a PO for 50 laptops from Dell at $1,200 each"
- "Compare these 3 vendor quotes and recommend"
- "Analyze our Q1 procurement spend"
- "Prep me for renegotiating our AWS contract"

## Need More?

This skill covers procurement fundamentals. For industry-specific procurement workflows (healthcare supply chain, construction materials, SaaS vendor management), check out our full context packs:

**[AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47 each, 10 industries covered.

**[AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)** — Find out how much manual procurement costs your team.

**[Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)** — Get your AI agent configured in minutes.

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/)
