# Pricing Strategy Analyzer

Analyze and optimize pricing for any product or service. Covers value-based, cost-plus, competitive, and tiered pricing models.

## What It Does
- Runs pricing power analysis (1% price increase = 12.5% profit increase for most businesses)
- Calculates willingness-to-pay ranges using Van Westendorp methodology
- Models tier structures (Good/Better/Best) with anchor pricing
- Identifies pricing mistakes: leaving money on table, racing to bottom, ignoring segments
- Generates competitor pricing matrices
- Produces actionable pricing recommendations with revenue impact estimates

## Usage
Ask your agent: "Analyze pricing for [product/service]" or "Help me set pricing for [new offering]"

Provide:
- Current pricing (if any)
- Target customer segment
- Key competitors and their pricing
- Cost structure (fixed + variable)
- Current conversion rate and volume

The agent will return a full pricing analysis with specific recommendations and projected revenue impact.

## Pricing Frameworks Included

### Value-Based Pricing
Calculate price based on quantified customer value, not your costs. The #1 pricing mistake is anchoring to cost instead of value delivered.

### Tiered Pricing (Good/Better/Best)
- **Good**: Entry point, captures price-sensitive segment (60-70% of value)
- **Better**: Sweet spot, where most revenue comes from (85-90% of value)  
- **Best**: Premium anchor that makes Better look reasonable (100%+ of value)

### Competitive Positioning
- Premium (20-50% above market): requires clear differentiation
- Parity (±10%): compete on features/experience
- Penetration (20-40% below): volume play, requires cost advantage

### Price Elasticity Quick Test
- Drop price 10%, measure volume change
- If volume increases <10% → you have pricing power, raise prices
- If volume increases >15% → you're in elastic territory, optimize for volume

## Key Metrics to Track
- **ACV** (Annual Contract Value) — are deals getting bigger or smaller?
- **Discount frequency** — if >30% of deals need discounts, your list price is wrong
- **Time-to-close by price point** — longer cycles at higher prices may still be more profitable
- **Expansion revenue %** — best signal that your pricing captures ongoing value

## Resources
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where you're losing money
- [AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/) — Industry-specific agent configs ($47/pack)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Get your AI agent running in minutes
