# Presentation Mastery — Complete Slide Design & Delivery System

Build presentations that persuade, inform, and move people to action. From audience analysis to delivery coaching — the complete system.

## What This Does

Most presentation skills help you generate slides. This one makes you a better presenter.

- **Audience analysis** — empathy mapping, format selection, context brief
- **Narrative architecture** — 5 proven story frameworks (Problem→Solution→Proof, SCR, Hero's Journey, and more)
- **Slide design system** — 10 slide type templates, visual design rules, quality scoring
- **5 complete deck templates** — investor pitch, board update, conference talk, sales presentation, team all-hands
- **Delivery coaching** — rehearsal protocol, timing guides, body language, Q&A handling, virtual presentation tips
- **100-point review rubric** — score and improve any deck across 8 dimensions
- **Advanced techniques** — storytelling devices, difficult situations playbook, deck versioning

## Install

```bash
clawhub install afrexai-presentation-mastery
```

## Quick Start

Tell your agent:
- "Help me build a presentation about [topic]"
- "I need a pitch deck for investors"
- "Review my slide deck"
- "Coach me for my presentation tomorrow"
- "I have 10 minutes to present quarterly results"

The skill walks you through the full process — no design tools required.

## Why This vs. Other Presentation Skills

Other skills generate HTML/PDF slides using APIs. This one teaches your agent the *methodology* of great presentations — narrative structure, visual design principles, audience psychology, delivery coaching. Zero dependencies.

## ⚡ Level Up

Want industry-specific presentation templates and messaging frameworks?

**[AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/)** — $47 each, packed with vertical-specific strategies:

- **SaaS Context Pack** — investor pitch frameworks, product demo structures, QBR templates
- **Professional Services Pack** — client proposal decks, thought leadership presentations
- **Recruitment Pack** — employer brand presentations, hiring committee decks

## 🔗 More Free Skills by AfrexAI

- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — Complete B2B sales system
- [afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy) — Brand identity & GTM
- [afrexai-meeting-mastery](https://clawhub.com/skills/afrexai-meeting-mastery) — Meeting prep & follow-up
- [afrexai-proposal-engine](https://clawhub.com/skills/afrexai-proposal-engine) — Win more deals
- [afrexai-founder-os](https://clawhub.com/skills/afrexai-founder-os) — Startup operating system

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
