# PRD Engine — Product Requirements That Ship

The most comprehensive PRD skill on ClawHub. Not just a JSON template — a complete product requirements methodology from discovery to post-launch review.

## What You Get

- **Discovery Brief** — Problem validation checklist with kill criteria (stop bad PRDs before they start)
- **Full PRD Template** — 7-section document with edge cases, release plan, success metrics
- **Quality Rubric** — 100-point scoring system across 7 dimensions (score before sharing)
- **INVEST Story Methodology** — Right-sized stories with verifiable acceptance criteria
- **AI Agent Mode** — Optimized story format for Claude Code, Cursor, Copilot (file paths, verification commands, done-when)
- **Dependency Pyramid** — 6-level ordering system so you never build UI before the API exists
- **Splitting Strategies** — 6 patterns for breaking XL stories into shippable slices
- **Post-Launch Review** — Template for measuring if the feature actually worked
- **Progress Tracking** — Velocity + completion + blocker escalation

## Install

```bash
clawhub install afrexai-prd-engine
```

## Quick Start

```
"Write a PRD for [feature name]"
"Break this into stories: [feature description]"
"Review this PRD and score it"
"Make these stories agent-ready for Claude Code"
```

## Why This Over Alternatives

| Feature | Basic PRD Skills | PRD Engine |
|---------|-----------------|------------|
| Problem validation | ❌ | ✅ Discovery brief + kill criteria |
| Story methodology | Basic JSON | INVEST + sizing + 6 split strategies |
| Quality scoring | ❌ | ✅ 100-point rubric, 7 dimensions |
| AI agent support | ❌ | ✅ File paths, commands, done-when |
| Edge case coverage | ❌ | ✅ Empty, error, slow, permissions, concurrent |
| Post-launch review | ❌ | ✅ Metrics + retro + iterate/kill decision |
| Approval workflow | ❌ | ✅ Review checklist + common feedback fixes |

## ⚡ Level Up

Want a complete product management system with market analysis, competitive positioning, and go-to-market strategy?

**[SaaS AI Context Pack — $47](https://afrexai-cto.github.io/context-packs/)** — Full SaaS operational context including product strategy, pricing, metrics, and growth frameworks.

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Autonomous lead generation engine
- [afrexai-competitive-intel](https://clawhub.com/skills/afrexai-competitive-intel) — 7-phase competitive intelligence system
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Complete pricing methodology
- [afrexai-proposal-engine](https://clawhub.com/skills/afrexai-proposal-engine) — Deal-winning proposal system
- [afrexai-business-automation](https://clawhub.com/skills/afrexai-business-automation) — 5-phase automation lifecycle

**Browse all AfrexAI skills →** https://afrexai-cto.github.io/context-packs/
