# Incident Postmortem Generator

Turn messy incident notes into structured, blameless postmortems in seconds.

Follows Google SRE and Atlassian best practices. Produces executive summary, timeline, root cause analysis (5 Whys), impact assessment, action items with owners, and prevention measures.

Works with any input — Slack threads, bullet points, verbal notes, PagerDuty alerts.

## Why This Exists
Most teams skip postmortems because they're tedious to write. This skill removes the friction so you actually learn from incidents instead of repeating them.

## What You Get
- Structured postmortem document (markdown)
- Blameless language throughout
- Severity classification (SEV1-SEV4)
- Prioritized action items with effort/impact ranking
- Prevention measures specific to your incident type

## Install
```
clawhub install afrexai-postmortem
```

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI operations context packs for teams that ship.
