# Portfolio Risk Analyzer

Complete investment portfolio risk management system. Analyze positions, calculate risk metrics, stress test scenarios, optimize allocations, and generate institutional-grade risk reports — all without external APIs.

---

## 1. Portfolio Intake

When the user shares their portfolio (positions, tickers, amounts), structure it into this format:

```yaml
portfolio:
  name: "User Portfolio"
  currency: USD
  as_of: "2026-02-15"
  positions:
    - ticker: AAPL
      shares: 50
      avg_cost: 185.00
      current_price: 228.50  # Look up via web search
      asset_class: US_EQUITY
      sector: Technology
    - ticker: BTC
      units: 0.5
      avg_cost: 42000
      current_price: 97500
      asset_class: CRYPTO
      sector: Digital Assets
    - ticker: VOO
      shares: 100
      avg_cost: 410.00
      current_price: 535.00
      asset_class: US_EQUITY_ETF
      sector: Broad Market
  cash:
    amount: 15000
    currency: USD
```

### Price Lookup
For each position, use web search to find current price:
- Search: `[TICKER] stock price today`
- For crypto: `[COIN] price USD today`
- Record source and timestamp

### Portfolio Summary Table

| Position | Shares | Cost Basis | Current Value | Weight | P&L | P&L % |
|----------|--------|-----------|---------------|--------|-----|-------|
| AAPL | 50 | $9,250 | $11,425 | 18.2% | +$2,175 | +23.5% |
| ... | ... | ... | ... | ... | ... | ... |
| **TOTAL** | | **$XX,XXX** | **$XX,XXX** | **100%** | **±$X,XXX** | **±X.X%** |

---

## 2. Risk Metrics Calculator

Calculate ALL of the following for every portfolio analysis:

### 2.1 Concentration Risk

```
Position Concentration:
- Any single position >20% of portfolio = HIGH RISK ⚠️
- Any single position >10% = MODERATE RISK
- Top 3 positions >50% = CONCENTRATED

Sector Concentration:
- Any sector >30% = OVERWEIGHT
- Count unique sectors — fewer than 4 = UNDER-DIVERSIFIED

Asset Class Breakdown:
- Equities: X%
- Fixed Income: X%
- Crypto: X%
- Cash: X%
- Alternatives: X%
```

### 2.2 Value at Risk (VaR) — Parametric Method

Calculate the maximum expected loss at given confidence levels:

```
Daily VaR Calculation:
1. Look up each position's historical volatility (annualized)
   - Use web search: "[TICKER] historical volatility 30 day"
   - Typical ranges: Large cap stocks 15-25%, Crypto 50-80%, Bonds 5-10%

2. Convert to daily volatility:
   Daily Vol = Annual Vol / √252

3. Position VaR (95% confidence):
   Position VaR = Position Value × Daily Vol × 1.645

4. Position VaR (99% confidence):
   Position VaR = Position Value × Daily Vol × 2.326

5. Portfolio VaR (simplified — assumes correlation ≈ 0.5 for stocks):
   Portfolio VaR ≈ √(Σ(Position VaR²) + 2×0.5×Σ(VaR_i × VaR_j))

Report:
- 1-Day 95% VaR: $X,XXX (X.X% of portfolio)
- 1-Day 99% VaR: $X,XXX (X.X% of portfolio)
- 10-Day 95% VaR: $X,XXX (= 1-Day VaR × √10)
- Monthly 95% VaR: $X,XXX (= 1-Day VaR × √21)
```

### 2.3 Maximum Drawdown Estimation

```
Based on asset class historical max drawdowns:
- US Large Cap: -50% (2008-09), typical correction -20%
- US Small Cap: -55%, typical correction -25%
- International Equity: -55%, typical -25%
- Emerging Markets: -65%, typical -30%
- Investment Grade Bonds: -15%, typical -5%
- High Yield Bonds: -30%, typical -10%
- REITs: -70%, typical -25%
- Crypto (BTC): -85%, typical -50%
- Gold: -45%, typical -15%
- Cash: 0%

Portfolio Max Drawdown Estimate:
= Σ(Position Weight × Asset Class Max Drawdown)

Report:
- Estimated worst-case drawdown: -$XX,XXX (XX.X%)
- Estimated typical correction: -$XX,XXX (XX.X%)
- Recovery time estimate: X-X months (based on historical averages)
```

### 2.4 Beta & Market Sensitivity

```
For each equity position:
- Look up beta via web search: "[TICKER] beta"
- Portfolio Beta = Σ(Position Weight × Position Beta)

Interpretation:
- Beta > 1.2: Portfolio is AGGRESSIVE (amplifies market moves)
- Beta 0.8-1.2: Portfolio is NEUTRAL
- Beta < 0.8: Portfolio is DEFENSIVE
- Negative beta positions: HEDGE value

Market Impact:
- If S&P 500 drops 10%, portfolio expected to move: Beta × -10%
```

### 2.5 Sharpe Ratio Estimation

```
Portfolio Expected Return = Σ(Weight × Expected Return)
Where Expected Return by asset class:
- US Large Cap: 8-10% annually
- US Small Cap: 9-11%
- International Developed: 6-8%
- Emerging Markets: 8-12%
- Investment Grade Bonds: 4-5%
- High Yield: 6-7%
- Crypto: highly variable (use 0% for conservative estimate)
- REITs: 7-9%
- Cash: current money market rate (~4.5%)

Risk-Free Rate: current 3-month T-bill rate (search if needed)

Sharpe Ratio = (Portfolio Expected Return - Risk-Free Rate) / Portfolio Volatility

Rating:
- > 1.0: EXCELLENT risk-adjusted returns
- 0.5-1.0: GOOD
- 0-0.5: MEDIOCRE — consider rebalancing
- < 0: POOR — return doesn't justify risk
```

### 2.6 Income Analysis

```
For dividend-paying positions:
- Look up dividend yield: "[TICKER] dividend yield"
- Annual Income = Shares × Annual Dividend per Share
- Portfolio Yield = Total Annual Dividends / Portfolio Value

Report:
- Monthly estimated income: $XXX
- Annual estimated income: $X,XXX
- Yield on cost: X.X%
- Current yield: X.X%
```

---

## 3. Stress Testing

Run these scenarios against the portfolio and report impact:

### 3.1 Standard Scenarios

```yaml
scenarios:
  market_crash_2008:
    name: "2008 Financial Crisis"
    impacts:
      US_EQUITY: -0.50
      INTL_EQUITY: -0.55
      EMERGING: -0.60
      BONDS: +0.05
      HIGH_YIELD: -0.30
      REITS: -0.70
      CRYPTO: -0.80  # projected based on risk profile
      GOLD: +0.10
      CASH: 0

  covid_crash_2020:
    name: "COVID-19 Crash (Feb-Mar 2020)"
    impacts:
      US_EQUITY: -0.34
      INTL_EQUITY: -0.35
      EMERGING: -0.35
      BONDS: +0.03
      HIGH_YIELD: -0.20
      REITS: -0.40
      CRYPTO: -0.50
      GOLD: -0.05
      CASH: 0

  dot_com_2000:
    name: "Dot-Com Bust (2000-2002)"
    impacts:
      US_EQUITY: -0.45
      TECH: -0.75  # Apply to technology sector specifically
      INTL_EQUITY: -0.40
      BONDS: +0.15
      CASH: 0

  rate_hike_shock:
    name: "Rapid Rate Hike (+300bps)"
    impacts:
      US_EQUITY: -0.15
      BONDS: -0.15
      HIGH_YIELD: -0.10
      REITS: -0.25
      CRYPTO: -0.20
      GOLD: -0.10
      CASH: +0.01  # higher yields

  inflation_surge:
    name: "Stagflation (persistent 8%+ inflation)"
    impacts:
      US_EQUITY: -0.20
      BONDS: -0.20
      CRYPTO: -0.10  # debatable hedge
      GOLD: +0.15
      REITS: -0.05
      COMMODITIES: +0.20
      CASH: -0.03  # real value erosion

  crypto_winter:
    name: "Crypto Winter (80% drawdown)"
    impacts:
      CRYPTO: -0.80
      US_EQUITY: -0.05  # minor contagion
```

### 3.2 Stress Test Report Format

For each scenario:
```
📉 SCENARIO: [Name]

| Position | Current Value | Stressed Value | Loss |
|----------|--------------|----------------|------|
| AAPL     | $11,425      | $5,713         | -$5,712 |
| ...      | ...          | ...            | ...  |
| TOTAL    | $XX,XXX      | $XX,XXX        | -$XX,XXX (-XX.X%) |

Could you survive this? [YES/NO based on cash reserves and income needs]
Recovery estimate: X-X months
```

### 3.3 Custom Scenario Builder

If user describes a specific worry, build a custom scenario:
```
User: "What if tech crashes 40% but bonds rally?"
→ Build custom impact map, apply to portfolio, report results
```

---

## 4. Portfolio Optimization

### 4.1 Current Allocation Assessment

```
Compare current allocation to standard models:

AGGRESSIVE (Age <35, high risk tolerance):
  Equities: 80-90%, Bonds: 5-10%, Alternatives: 5-10%, Cash: 2-5%

GROWTH (Age 35-50):
  Equities: 60-75%, Bonds: 15-25%, Alternatives: 5-10%, Cash: 5%

BALANCED (Age 50-60):
  Equities: 40-60%, Bonds: 30-40%, Alternatives: 5-10%, Cash: 5-10%

CONSERVATIVE (Age 60+, income focus):
  Equities: 20-40%, Bonds: 40-50%, Alternatives: 5%, Cash: 10-20%

Current allocation matches: [MODEL] profile
Recommended adjustments: [specific moves]
```

### 4.2 Risk Parity Analysis

```
Risk Parity Target: Each asset class contributes EQUAL risk to portfolio

Steps:
1. Calculate each position's risk contribution:
   Risk Contribution = Weight × Volatility × Correlation_with_portfolio

2. For equal risk contribution:
   Target Weight_i = (1/Vol_i) / Σ(1/Vol_j)

3. Report:
   Current vs Risk-Parity weights
   Trades needed to rebalance
   Expected impact on Sharpe Ratio
```

### 4.3 Rebalancing Recommendations

```
Check rebalancing triggers:
- Any position drifted >5% from target? → REBALANCE
- Any asset class drifted >10% from target? → REBALANCE
- Last rebalance >6 months ago? → REVIEW

Rebalancing Method:
1. Calculate target weights
2. Calculate current weights
3. Determine trades needed (minimize transactions)
4. Tax-lot optimization: sell highest-cost lots first (minimize tax)
5. Consider wash sale rules if harvesting losses

Output trade list:
| Action | Ticker | Shares | Est. Value | Reason |
|--------|--------|--------|-----------|--------|
| SELL   | AAPL   | 15     | $3,428    | Overweight tech |
| BUY    | BND    | 25     | $1,850    | Underweight bonds |
```

### 4.4 Correlation Analysis

```
Assess diversification quality:

HIGH correlation pairs (>0.7) — these DON'T diversify each other:
- Tech stocks with each other
- US equity ETFs with each other
- High yield bonds with equities

LOW correlation pairs (<0.3) — TRUE diversifiers:
- Stocks vs Treasury bonds
- US vs Gold
- Equities vs Managed Futures

NEGATIVE correlation — HEDGES:
- Long equity + Put options
- Stocks + VIX products
- Growth + Value in some regimes

Grade portfolio diversification: A/B/C/D/F
```

---

## 5. Risk Score Card (0-100)

Generate a single risk score:

```yaml
risk_scorecard:
  concentration_risk:
    weight: 20
    score: X  # 100 = well diversified, 0 = single stock
    details: "Top position is X%, X sectors represented"

  volatility_risk:
    weight: 20
    score: X  # 100 = low vol, 0 = extremely volatile
    details: "Portfolio annualized vol: X%"

  drawdown_risk:
    weight: 20
    score: X  # 100 = minimal drawdown exposure, 0 = could lose 50%+
    details: "Max estimated drawdown: X%"

  liquidity_risk:
    weight: 15
    score: X  # 100 = all highly liquid, 0 = illiquid positions
    details: "X% in liquid large-cap, X% in illiquid"

  income_resilience:
    weight: 10
    score: X  # 100 = strong income, 0 = no yield
    details: "Portfolio yield: X%, X% from reliable dividend payers"

  market_sensitivity:
    weight: 15
    score: X  # 100 = low beta/defensive, 0 = highly aggressive
    details: "Portfolio beta: X.XX"

  overall_score: X/100
  rating: "[CONSERVATIVE|MODERATE|AGGRESSIVE|SPECULATIVE]"
  recommendation: "[Key action item]"
```

### Score Interpretation
- 80-100: FORTRESS — Well-protected, may be too conservative for growth
- 60-79: SOLID — Good risk management, minor improvements possible
- 40-59: MODERATE — Reasonable but has notable risk exposures
- 20-39: ELEVATED — Significant vulnerabilities, rebalancing recommended
- 0-19: DANGER ZONE — Extreme concentration or volatility, urgent action needed

---

## 6. Monitoring & Alerts

### Daily Check Template (for cron/heartbeat use)

```
For each portfolio position:
1. Check price vs previous close (web search)
2. Flag if any position moved >3% in a day
3. Flag if any position hit stop-loss level
4. Check for earnings/events in next 7 days

Alert Thresholds:
- Single position -5% in a day → ALERT
- Portfolio -3% in a day → ALERT
- Position hits 52-week low → WATCH
- VIX > 25 → ELEVATED CAUTION
- VIX > 35 → HIGH ALERT — review hedges
```

### Weekly Review Template

```markdown
## Portfolio Weekly Review — [Date]

### Performance
- Portfolio value: $XX,XXX (±X.X% week)
- Best performer: [TICKER] +X.X%
- Worst performer: [TICKER] -X.X%
- vs S&P 500: [outperformed/underperformed] by X.X%

### Risk Changes
- VaR change: $X,XXX → $X,XXX
- Any new concentration issues? [Y/N]
- Rebalancing needed? [Y/N]

### Upcoming Events
- Earnings: [tickers and dates]
- Ex-dividend dates: [tickers and dates]
- Fed/macro events: [list]

### Action Items
1. [Specific recommendation]
2. [Specific recommendation]
```

---

## 7. Tax-Loss Harvesting Scanner

```
For each position with unrealized losses:
1. Calculate unrealized loss: (Current Price - Avg Cost) × Shares
2. Check if loss >$500 (worth harvesting)
3. Identify tax-efficient replacement:
   - Same sector ETF (avoids wash sale)
   - Similar factor exposure
   - Hold replacement 31+ days before switching back

Report:
| Ticker | Unrealized Loss | Replacement | Wash Sale Clear Date |
|--------|----------------|-------------|---------------------|
| XYZ    | -$2,500        | Similar ETF | [date + 31 days]   |

Estimated tax savings: $X,XXX (at X% marginal rate)
```

---

## 8. Special Asset Classes

### Crypto Portfolio Risk

Additional crypto-specific metrics:
- Bitcoin dominance correlation
- Exchange risk (centralized vs self-custody)
- Protocol risk for DeFi positions
- Stablecoin exposure and depeg risk
- Tax implications of staking/yield

### Real Estate (REITs/Property)

- FFO yield vs dividend yield
- Interest rate sensitivity
- Geographic concentration
- Property type diversification (residential/commercial/industrial)

### Options Positions

If portfolio includes options:
- Delta exposure (equivalent stock position)
- Theta decay (daily time value loss)
- Implied volatility vs historical
- Max loss calculation
- Breakeven prices

---

## 9. Report Generation

### Full Risk Report (on request)

Generate a complete PDF-ready markdown report:

```markdown
# Portfolio Risk Report
## Prepared: [Date]
## Portfolio: [Name]

### Executive Summary
[2-3 sentence overview: total value, risk rating, top recommendation]

### 1. Holdings Summary
[Position table from Section 1]

### 2. Risk Metrics
[All calculations from Section 2]

### 3. Stress Test Results
[All scenarios from Section 3]

### 4. Optimization Recommendations
[From Section 4]

### 5. Risk Scorecard
[From Section 5]

### 6. Action Plan
[Prioritized list of recommended changes]

### Disclaimer
This analysis is for informational purposes only and does not constitute
financial advice. Past performance and historical data do not guarantee
future results. Consult a qualified financial advisor before making
investment decisions.
```

---

## 10. Quick Commands

Respond to these natural language requests:

| User Says | Action |
|-----------|--------|
| "Analyze my portfolio" | Full Section 1-5 analysis |
| "What's my risk?" | Risk Scorecard (Section 5) |
| "Stress test my portfolio" | All scenarios (Section 3) |
| "What if the market crashes?" | 2008 + COVID scenarios |
| "How should I rebalance?" | Section 4 optimization |
| "Tax loss harvest" | Section 7 scanner |
| "Weekly review" | Section 6 weekly template |
| "Add [position]" | Update portfolio YAML, recalculate |
| "Remove [position]" | Update portfolio YAML, recalculate |
| "What's my VaR?" | Value at Risk calculation (Section 2.2) |
| "Compare to S&P 500" | Benchmark comparison |
| "How diversified am I?" | Concentration + correlation analysis |
| "What's my Sharpe ratio?" | Section 2.5 |
| "Set alert for [ticker] at [price]" | Add to monitoring (Section 6) |

---

## Edge Cases

### Small Portfolios (<$10K)
- Skip VaR (not meaningful for small amounts)
- Focus on concentration risk and savings rate
- Recommend index-first approach

### Single Stock Portfolios (e.g., company RSUs)
- ALWAYS flag extreme concentration risk
- Model collar strategies (protective put + covered call)
- 10b5-1 plan reminder for insiders
- Calculate how much to diversify per quarter

### Crypto-Heavy (>50% crypto)
- Apply crypto winter scenario prominently
- Flag exchange counterparty risk
- Recommend cold storage percentage
- Note tax complexity of DeFi/staking

### International Portfolios
- Currency risk calculation
- Country risk premium
- Withholding tax impact on dividends
- ADR vs local share considerations

### Leveraged Positions (margin/options)
- Calculate margin call price
- Stress test at 2x normal drawdown
- Flag if margin utilization >50%
- Model forced liquidation scenarios

### Retirement Accounts (IRA/401k)
- Different tax treatment (no tax-loss harvesting needed)
- RMD impact for traditional IRA
- Roth conversion opportunity analysis
- Sequence of returns risk for near-retirees
