# Portfolio Risk Analyzer

**Institutional-grade portfolio risk management for AI agents.** Analyze positions, calculate VaR, stress test against historical crashes, optimize allocations, and generate professional risk reports — zero dependencies, no API keys required.

## Install

```bash
clawhub install afrexai-portfolio-risk
```

## What It Does

- **Risk Metrics**: Value at Risk (VaR), Sharpe Ratio, Beta, Max Drawdown, Concentration Risk
- **Stress Testing**: 6 pre-built scenarios (2008 crash, COVID, dot-com, rate shock, stagflation, crypto winter) + custom
- **Portfolio Optimization**: Risk parity analysis, rebalancing recommendations, correlation assessment
- **Risk Scorecard**: 0-100 composite score across 6 weighted dimensions
- **Tax-Loss Harvesting**: Automated scanner with wash-sale-safe replacements
- **Monitoring**: Daily alerts, weekly review templates, earnings calendar
- **Special Assets**: Crypto, REITs, options, leveraged positions, international

## Quick Start

Tell your agent:
> "Here's my portfolio: 50 shares AAPL, 100 shares VOO, 0.5 BTC, $15K cash. Analyze my risk."

The agent will look up current prices, calculate all risk metrics, run stress tests, and deliver a complete risk scorecard.

## Example Commands

- "What's my portfolio risk?"
- "Stress test against a 2008-style crash"
- "How should I rebalance?"
- "What's my Value at Risk?"
- "Scan for tax-loss harvesting opportunities"
- "Generate a full risk report"

## Why This vs Other Tools

Most portfolio tools require paid API subscriptions or only work with specific brokerages. This skill uses web search for live prices and works with any portfolio — stocks, crypto, bonds, REITs, options. Pure agent intelligence, zero vendor lock-in.

---

⚡ **Level up your financial AI agent:**

- [Fintech AI Context Pack ($47)](https://afrexai-cto.github.io/context-packs/) — Complete fintech agent context: compliance frameworks, risk models, regulatory intelligence
- [SaaS Context Pack ($47)](https://afrexai-cto.github.io/context-packs/) — Unit economics, pricing strategy, SaaS metrics

🔗 **More free skills by AfrexAI:**

- `afrexai-budget-tracker` — Personal & business budget management
- `afrexai-data-analyst` — Complete data analysis methodology (DICE framework)
- `afrexai-competitive-intel` — Business competitive intelligence system
- `afrexai-pricing-strategy` — Full pricing system with Van Westendorp research
- `afrexai-negotiation-mastery` — 7-phase negotiation system

📦 [Browse all AfrexAI context packs →](https://afrexai-cto.github.io/context-packs/)
