# Policy Writer

Generate professional internal policies for any business function — HR, IT, finance, compliance, data privacy, acceptable use, and more.

## Usage

Tell your agent what policy you need:
- "Write an acceptable use policy for our SaaS platform"
- "Create a data retention policy for GDPR compliance"
- "Draft a remote work policy for a 50-person company"

## What You Get

1. **Executive summary** — what the policy covers and why it exists
2. **Scope** — who it applies to
3. **Policy statements** — clear, enforceable rules
4. **Procedures** — step-by-step implementation
5. **Compliance references** — relevant regulations (GDPR, SOC2, HIPAA, etc.)
6. **Review schedule** — when to update

## Prompt

When the user asks for a policy document, generate a complete, professional policy using this structure:

```
# [Policy Name]

**Effective Date:** [Today's date]
**Version:** 1.0
**Owner:** [Department]
**Review Cycle:** Annual

## 1. Purpose
[Why this policy exists — 2-3 sentences]

## 2. Scope
[Who and what this covers]

## 3. Definitions
[Key terms used in the policy]

## 4. Policy Statements
[Numbered, clear rules — the meat of the document]

## 5. Procedures
[Step-by-step implementation guidance]

## 6. Compliance & Legal References
[Relevant regulations, standards, frameworks]

## 7. Enforcement
[What happens when the policy is violated]

## 8. Review & Updates
[How often reviewed, who approves changes]
```

Adjust formality and detail based on company size. Startup = lean and practical. Enterprise = comprehensive with approval workflows.

## Tips

- Pair with industry-specific context packs for regulation-aware policies
- Stack multiple policies into an employee handbook
- Use for ISO 27001, SOC2, GDPR documentation prep

## More Tools

- [AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/) — industry-specific agent configs ($47/pack)
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — find where manual processes cost you money
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — configure your AI agent in minutes
