---
name: Photography Mastery
description: Complete photography system — exposure, composition, lighting, genre-specific workflows, editing, gear selection, portfolio building, and client management. From beginner to professional.
metadata:
  category: creative
  skills: ["photography", "camera", "lighting", "editing", "composition", "portrait", "landscape", "street", "product", "wedding", "real-estate"]
---

# Photography Mastery — Complete System

> From "auto mode" to professional-quality images. Zero external dependencies.

## Quick Health Check (`/photo-check`)

Rate yourself 1-5 on each. Score < 24 = focus on fundamentals first.

| Dimension | 1 (Beginner) | 3 (Intermediate) | 5 (Advanced) |
|---|---|---|---|
| Exposure control | Auto mode only | Manual in studio | Expose by feel, nail it first shot |
| Composition | Center everything | Rule of thirds | Break rules intentionally with impact |
| Lighting | Available light only | One flash, bounce | Multi-light setups, shape light |
| Focus technique | Auto everything | Back-button AF | Zone focus, manual in low light |
| Post-processing | Phone filters | Basic Lightroom | Color grading, frequency separation |
| Genre knowledge | Shoot everything same | 1-2 genres solid | Specialist with signature style |
| Gear understanding | Kit lens only | Know focal lengths | Choose lens for the story |
| Business/portfolio | Instagram only | Basic portfolio site | Paying clients, defined brand |

**Total: ___ / 40** → <16: Phase 1-3. 16-28: Phase 4-7. 28+: Phase 8-12.

---

## Phase 1: Exposure Mastery

### The Exposure Triangle (Internalize, Don't Memorize)

```
LIGHT IN = ISO × Aperture × Shutter Speed

Change one → compensate with another → same exposure, different look.
```

**ISO** — Sensor sensitivity
| ISO | Use case | Trade-off |
|---|---|---|
| 100-400 | Daylight, tripod, studio | Clean, no noise |
| 400-1600 | Indoor, overcast, golden hour | Slight grain, acceptable |
| 1600-6400 | Low light handheld, events | Visible noise, still usable |
| 6400+ | Emergency, concert, astro | Heavy noise, denoise in post |

**Rule:** Lowest ISO that allows your shutter speed. Modern cameras: ISO 3200 is fine.

**Aperture** — Depth of field + sharpness
| f-stop | Depth of field | Best for |
|---|---|---|
| f/1.4-2.0 | Paper thin | Headshots, subject isolation, low light |
| f/2.8-4.0 | Shallow | Portraits (full body still sharp enough) |
| f/5.6-8.0 | Medium | Groups, environmental portraits, street |
| f/8-11 | Deep | Landscapes, architecture, products |
| f/16-22 | Everything sharp | Avoid — diffraction softens image |

**Sweet spot rule:** Most lenses are sharpest 2-3 stops from wide open. f/1.4 lens → sharpest at f/4.

**Shutter Speed** — Motion control
| Speed | Effect | Use |
|---|---|---|
| 1/2000+ | Freeze everything | Sports, birds, splashing water |
| 1/500-1/1000 | Freeze people | Running, dancing, events |
| 1/125-1/250 | General handheld | Walking, portraits, street |
| 1/60 | Minimum handheld | With IS/VR, careful technique |
| 1/15-1/4 | Motion blur | Panning, waterfalls (tripod) |
| 1-30s | Long exposure | Night, light trails, star points |
| 30s+ (bulb) | Extended exposure | Star trails, light painting |

**Handheld rule:** 1/(focal length × crop factor). 50mm on APS-C (1.5×) = minimum 1/75s.

### Metering Modes — When to Use Each

| Mode | What it reads | Use when |
|---|---|---|
| Evaluative/Matrix | Whole frame, smart weighting | Default — works 80% of time |
| Center-weighted | Middle 60% of frame | Subject fills center, ignore edges |
| Spot | 2-5% around focus point | Backlit subjects, stage performances |

### Exposure Compensation Quick Reference

| Situation | Adjustment | Why |
|---|---|---|
| Snow/white backgrounds | +1 to +2 | Camera tries to make white gray |
| Dark backgrounds/subjects | -1 to -2 | Camera tries to brighten dark |
| Backlit subject | +1 to +2 | Expose for subject, not bright background |
| Skin tones (portrait) | +1/3 to +2/3 | Slightly overexposed skin looks healthier |

### Histogram Reading

```
Left wall = pure black (clipped shadows)
Right wall = pure white (clipped highlights)

GOAL: Data spread across range, nothing touching walls
EXCEPTION: Night shots (left-heavy OK), high-key portraits (right-heavy OK)

ETTR (Expose To The Right): Push histogram right without clipping = maximum data, minimum noise.
Best for: Landscapes, studio. Requires RAW shooting.
```

---

## Phase 2: Composition Framework

### The Composition Hierarchy (Most to Least Impact)

1. **Light** — Quality and direction of light makes or breaks any image
2. **Subject** — Clear subject, clear story. If you can't point to the subject, reshoot
3. **Simplification** — Remove distractions. Move feet, change angle, wait for clutter to clear
4. **Depth** — Foreground → midground → background creates dimension
5. **Lines & shapes** — Guide the eye, create structure
6. **Color & tone** — Harmony or contrast, either intentional

### 12 Composition Techniques (Beyond Rule of Thirds)

| Technique | How | Best for |
|---|---|---|
| Rule of thirds | Subject at intersection points | Default starting point |
| Center + symmetry | Subject dead center, symmetric frame | Architecture, reflections, portraits with impact |
| Leading lines | Roads, fences, rivers pointing to subject | Landscapes, street, architecture |
| Frame within frame | Doorways, windows, arches around subject | Travel, architecture, environmental portraits |
| Negative space | Vast empty area, tiny subject | Minimalism, emphasis, mood |
| Diagonals | Tilt horizon or use natural diagonals | Energy, dynamism |
| Layering | Stack foreground/mid/background elements | Landscapes, street |
| Patterns + break | Repeating pattern with one disruption | Street, architecture, abstract |
| Juxtaposition | Contrasting elements in same frame | Documentary, street, conceptual |
| Fill the frame | Get close, eliminate surroundings | Portraits, macro, food |
| Odd numbers | 3 or 5 subjects | Still life, group compositions |
| Golden spiral | Fibonacci curl — leading from edge to focal point | Nature, still life |

### Composition Mistakes That Kill Images

| Mistake | Fix |
|---|---|
| Horizon not level | Enable grid overlay. Fix in post if needed. Non-negotiable. |
| Mergers (pole from head) | Move 2 steps. Change angle. Check background before shooting. |
| Cutting at joints | Crop mid-limb (mid-thigh, mid-forearm) or full body. Never at knee/ankle/wrist/neck. |
| No clear subject | Ask: "What is this photo OF?" If you hesitate, simplify. |
| Too much in frame | Get closer. Zoom with feet. Fill frame with what matters. |
| Dead center without purpose | Either center with symmetry or offset with intention. |
| Tilted horizon | Landscape: always level. Portrait: tilt only if dramatic and intentional. |

---

## Phase 3: Light Mastery

### Natural Light Quality Guide

| Time | Quality | Color | Best for |
|---|---|---|---|
| Golden hour (sunrise/sunset ±1hr) | Soft, directional, warm | Orange/gold | Portraits, landscapes, everything |
| Blue hour (20-30 min after sunset) | Even, moody | Blue/purple | Cityscapes, mood portraits, twilight |
| Overcast | Soft, even (giant softbox) | Neutral | Portraits (no squinting), product, macro |
| Midday sun | Hard, overhead, high contrast | Neutral/warm | Use as backlight. Find open shade. Avoid for portraits. |
| Shade | Soft, directional from open sky | Slightly cool | Portraits, detail work |
| Window light | Soft directional (varies with window size) | Varies | Portraits, food, still life, product |

### Window Light Setup (Free Studio)

```
POSITION MAP (top-down view):

     [WINDOW]
        |
   45°  |  45°
  /     |     \
FILL   SUBJECT   CAMERA
(reflector)

Distance from window controls softness:
- Close (1-2 ft): soft wrapping light, gentle shadows
- Far (6+ ft): harder, more directional, defined shadows
- Subject facing window: flat, even (beauty light)
- Subject 45° to window: dimensional, classic portrait
- Subject 90° to window: dramatic, split lighting
```

**White reflector** opposite window fills shadows. **No reflector** = moody. Aluminum foil on cardboard = DIY reflector.

### Flash Fundamentals

**The #1 rule:** Never fire direct flash at a person. Bounce it or diffuse it.

| Technique | How | Result |
|---|---|---|
| Bounce ceiling | Tilt flash head 45-75° up | Soft overhead light, natural look |
| Bounce wall | Tilt flash 90° toward near wall | Directional side light |
| Flash + diffuser | Dome or mini softbox on flash | Softer direct flash (still not great) |
| Off-camera flash | Flash on stand, 45° from subject | Professional dimensional light |
| Dragging shutter | Flash + slow shutter (1/15-1/30) | Sharp subject + ambient background blur |

**Flash exposure compensation:** Start at -1.3 stops. Blend with ambient. If you can tell flash was used, it's too much.

### 5 Portrait Lighting Patterns

| Pattern | Key light position | Shadow | Mood |
|---|---|---|---|
| Rembrandt | 45° side, 45° above | Triangle on shadow cheek | Classic, moody |
| Loop | 30-45° side, slightly above | Small nose shadow loops toward cheek | Versatile, flattering |
| Butterfly | Directly above, centered | Shadow under nose (butterfly shape) | Beauty, glamour |
| Split | 90° from side | Half face in shadow | Dramatic, edgy |
| Broad | Key light on face side nearest camera | Wider lit area | Widens narrow faces |

---

## Phase 4: Focus & Sharpness

### Focus Mode Decision

| Situation | Mode | Why |
|---|---|---|
| Still subject (portrait, product) | Single AF (AF-S/One-Shot) | Locks focus, precise |
| Moving subject (sports, kids) | Continuous AF (AF-C/AI Servo) | Tracks movement |
| Unpredictable movement | Auto AF (AF-A) | Camera decides — last resort |
| Low light / precise work | Manual focus + magnify | AF hunts in dark, manual is reliable |

### Back-Button Focus (BBF) — Set This Up

Separate focus from shutter button:
- **AF-ON button** = focus
- **Shutter button** = only take photo

**Why:** Press AF-ON once = focus locks (like AF-S). Hold AF-ON = continuous tracking (like AF-C). One mode handles everything. Never accidentally refocus when pressing shutter.

### Sharpness Checklist

- [ ] Shutter speed ≥ 1/focal length (handheld rule)
- [ ] Aperture at sweet spot (f/5.6-f/8 for most lenses)
- [ ] ISO low enough to avoid noise softening
- [ ] Focus confirmed on intended target (magnify in live view)
- [ ] Image stabilization ON for handheld, OFF for tripod
- [ ] Clean front element (fingerprints kill contrast)
- [ ] Mirror lock-up for tripod (DSLR)
- [ ] Remote trigger or 2-second timer for tripod shots

---

## Phase 5: Genre-Specific Workflows

### Portrait Photography

**Pre-shoot checklist:**
```yaml
portrait_prep:
  gear:
    lens: "85mm f/1.8 (headshot) or 35mm f/1.4 (environmental)"
    reflector: "42-inch 5-in-1"
    backdrop: "depends on style"
  settings:
    mode: "aperture priority or manual"
    aperture: "f/2.0-2.8 (single), f/5.6 (group)"
    iso: "lowest possible"
    focus: "single point on nearest eye"
    metering: "spot on face"
  directing:
    warm_up: "5 min casual chat before picking up camera"
    posing_flow: "standing → leaning → sitting → detail shots"
    expression: "tell jokes, give them something to DO not something to BE"
    hands: "always doing something (pocket, hair, holding object)"
```

**Posing quick fixes:**
| Problem | Fix |
|---|---|
| Double chin | Extend chin forward and slightly down. Shoot from slightly above. |
| Awkward hands | Give them something to hold. Or one hand in pocket, other relaxed. |
| Stiff pose | Have them shift weight to back foot. Lean slightly forward. |
| Forced smile | Tell a joke. Ask them to laugh, then say "now freeze." |
| Squinting | Face away from light, turn back at last second. Or shade eyes until ready. |

### Landscape Photography

**Field checklist:**
```yaml
landscape_prep:
  planning:
    scout: "Google Earth + PhotoPills for sun/moon position"
    time: "arrive 45 min before golden hour"
    weather: "partly cloudy > clear blue (texture in sky)"
  gear:
    lens: "16-35mm (wide), 70-200mm (compression), 24-70mm (versatile)"
    tripod: "mandatory for quality"
    filters: "CPL (always), ND graduated (sky), ND 6/10 stop (long exposure)"
  settings:
    aperture: "f/8-f/11 (sweet spot)"
    iso: "100 (always on tripod)"
    focus: "manual at hyperfocal or 1/3 into scene"
    bracket: "±2 stops for HDR if high dynamic range"
  composition:
    foreground: "MANDATORY — rocks, flowers, leading lines"
    midground: "subject or connecting element"
    background: "sky, mountains, context"
```

**Hyperfocal distance (simplified):**
| Focal length | f/8 | f/11 | f/16 |
|---|---|---|---|
| 16mm | 1.1m | 0.8m | 0.5m |
| 24mm | 2.4m | 1.7m | 1.2m |
| 35mm | 5.1m | 3.7m | 2.5m |
| 50mm | 10.4m | 7.6m | 5.2m |

Focus at this distance → everything from half that distance to infinity is sharp.

### Street Photography

```yaml
street_settings:
  mode: "aperture priority"
  aperture: "f/5.6-f/8 (deep DOF for unpredictable scenes)"
  iso: "auto ISO, max 6400, min shutter 1/250"
  focus: "zone focus at 2-3m OR continuous AF"
  lens: "35mm (classic) or 28mm (wider context)"
  tips:
    - "Shoot from hip if nervous — practice without looking"
    - "Find the light first, then wait for subject to walk in"
    - "Layers: foreground person + background action = story"
    - "Rain, reflections, shadows = instant mood"
    - "One location, one hour, 200+ shots → 2-3 keepers = good ratio"
    - "If someone confronts you: smile, show the photo, offer to delete"
```

### Product Photography

```yaml
product_setup:
  minimum_gear:
    camera: "any with manual mode"
    lens: "50mm or kit lens at 50-70mm"
    light: "one window OR one continuous LED panel"
    surface: "white poster board curved (seamless sweep)"
    reflector: "white foam board or printer paper"
  settings:
    aperture: "f/8-f/11 (everything sharp)"
    iso: "100"
    white_balance: "manual — match light source"
    focus: "manual or single point on logo/label"
    tripod: "mandatory for consistency"
  shooting_checklist:
    - "Hero shot (3/4 angle, slightly above)"
    - "Straight-on front"
    - "45-degree angle"
    - "Detail/texture close-up"
    - "Scale shot (hand, common object for size)"
    - "Lifestyle/in-use shot"
    - "Flat lay (top-down for small items)"
```

### Real Estate Photography

```yaml
real_estate_workflow:
  gear:
    lens: "ultra-wide 16-24mm (full frame)"
    tripod: "mandatory"
    flash: "bounce flash for interior fill"
  technique:
    height: "camera at 4-5 feet (counter/chest height)"
    verticals: "MUST be straight — tilt-shift or fix in post"
    bracketing: "3-5 exposures, merge HDR"
    lights: "turn ALL lights on. Replace dead bulbs."
    staging: "declutter, remove personal items, fluff pillows"
  shot_list:
    exterior: ["front wide", "front detail", "backyard", "pool", "garage"]
    interior: ["living room 2-3 angles", "kitchen 2-3", "master bedroom", "master bath", "each additional room", "special features"]
    minimum: "25-35 photos for listing"
  editing:
    - "Correct verticals (lens correction)"
    - "Blend exposures for windows (interior + exterior visible)"
    - "Color correct to neutral — no yellow casts"
    - "Sky replacement if overcast (controversial but common)"
```

### Event/Wedding Photography

```yaml
event_essentials:
  gear:
    bodies: "2 minimum (backup is non-negotiable)"
    lenses: "24-70mm f/2.8 (workhorse) + 70-200mm f/2.8 (ceremony) + 35mm f/1.4 (reception)"
    flash: "2 speedlights + off-camera trigger"
    cards: "dual card slots, mirror write"
    batteries: "minimum 4 charged"
  settings:
    ceremony: "f/2.8, ISO auto (cap 6400), shutter 1/200+"
    reception: "f/2.8, ISO auto, flash bounce ceiling"
    formals: "f/5.6-f/8, flash on camera bounce"
  shot_list_non_negotiables:
    - "Rings, dress, shoes, invitation (detail shots BEFORE ceremony)"
    - "Getting ready (both parties)"
    - "Walking down aisle"
    - "First kiss"
    - "Recessional"
    - "Family formals (have LIST from client in advance)"
    - "First dance, parent dances"
    - "Cake cutting"
    - "Speeches/toasts"
    - "Venue wide shot"
  rules:
    - "Never run out of battery or cards during ceremony"
    - "Shoot in RAW+JPEG (safety net)"
    - "Second shooter for ceremony = different angles"
    - "Scout venue BEFORE event day"
    - "Deliver sneak peeks within 48 hours"
```

---

## Phase 6: Post-Processing Workflow

### RAW Processing Pipeline

```
1. IMPORT → Backup originals to second drive FIRST
2. CULL → Rate 1-5 stars. Delete obvious rejects. Select picks.
3. GLOBAL ADJUSTMENTS (apply to all picks):
   - White balance (eyedrop on neutral gray)
   - Exposure correction
   - Highlight recovery, shadow lift
   - Lens correction profile
   - Chromatic aberration removal
4. LOCAL ADJUSTMENTS (per image):
   - Crop and straighten
   - Dodge/burn (draw attention to subject)
   - Gradient filters (darken sky, lighten foreground)
   - Spot healing (blemishes, distractions)
5. COLOR GRADING:
   - HSL adjustments (skin tone, sky, foliage)
   - Split toning (warm highlights, cool shadows = cinematic)
   - Calibration panel (subtle, powerful)
6. SHARPENING:
   - Amount: 40-80 (web), 80-120 (print)
   - Radius: 0.8-1.2
   - Masking: hold Alt/Option while sliding — sharpen edges only
7. EXPORT:
   - Web: JPEG, sRGB, 2048px long edge, quality 80-85
   - Print: TIFF, AdobeRGB, full resolution
   - Social: JPEG, sRGB, 1080px (IG), 2048px (FB)
```

### Color Grading Quick Recipes

| Mood | Shadows | Highlights | Tone curve |
|---|---|---|---|
| Cinematic warm | Teal/blue | Orange/gold | Slight S-curve, lifted blacks |
| Moody dark | Deep blue | Desaturated warm | Crushed blacks, low highlights |
| Clean bright | Neutral | Slight warm | Lifted shadows, bright midtones |
| Film look | Green/brown | Warm | Faded blacks (lift curve bottom-left) |
| B&W dramatic | N/A | N/A | Strong S-curve, high contrast |

### Portrait Retouching Ethics Scale

| Level | What | When |
|---|---|---|
| 1 — Cleanup | Remove temporary blemishes (acne, stray hairs) | Always acceptable |
| 2 — Enhancement | Even skin tone, brighten eyes, whiten teeth slightly | Standard professional |
| 3 — Reshaping | Slim face/body, change proportions | Only if client requests |
| 4 — Transformation | Unrecognizable changes | Avoid — ethical issues |

**Rule:** Remove temporary, keep permanent. Pimple = remove. Freckles = keep. Scar = ask client.

---

## Phase 7: Gear Selection Guide

### Camera Selection Decision Matrix

| Need | Camera type | Budget | Examples |
|---|---|---|---|
| Learning, travel, street | Mirrorless APS-C | $500-1000 | Fuji X-S20, Sony a6700 |
| Portraits, events, pro | Mirrorless Full Frame | $1500-3000 | Sony A7IV, Nikon Z6III, Canon R6III |
| Sports, wildlife | Pro mirrorless | $2500-6500 | Sony A9III, Canon R5II, Nikon Z8 |
| Video-first hybrid | Cinema-oriented | $1500-4000 | Sony A7SIII, Panasonic S5IIX |
| Budget beginner | Used DSLR or entry mirrorless | $300-600 | Canon T7i, Nikon D5600, Sony a6100 |

### Lens Priority Order (Buy in This Order)

| Priority | Lens | Why |
|---|---|---|
| 1st | 50mm f/1.8 | "Nifty fifty" — sharp, fast, cheap ($100-250). Portraits, street, low light. |
| 2nd | Kit zoom (18-55 or 24-70) | Versatility while learning. Already have it. |
| 3rd | 85mm f/1.8 | Portrait king. Compression + bokeh. |
| 4th | Wide zoom (16-35mm) | Landscapes, architecture, real estate. |
| 5th | 70-200mm f/2.8 | Events, sports, wildlife. The "money maker" for pros. |
| 6th | Macro lens (90-100mm) | Products, food, nature details. |

**Rule:** Invest in lenses, not bodies. A great lens on a cheap body > cheap lens on great body. Lenses hold value. Bodies depreciate fast.

### Essential Accessories (Priority Order)

1. **Extra battery** (or two) — more important than any filter
2. **Fast SD card** (UHS-II, 128GB minimum) — slow cards = missed shots
3. **Tripod** — $100-200 range. Carbon fiber if carrying far. Aluminum if budget.
4. **Circular polarizer (CPL)** — cuts reflections, deepens sky. Buy for your most-used lens.
5. **Camera bag** — sling for street, backpack for hikes, roller for events
6. **Reflector** (42" 5-in-1) — $20. Turns one light into two.
7. **External flash** — bounce flash transforms events and indoor shoots

---

## Phase 8: Building a Portfolio

### Portfolio Architecture

```yaml
portfolio_structure:
  homepage:
    hero_image: "absolute best single image — stops scrolling"
    galleries: "3-5 genre galleries, 15-25 images each"
    about: "short bio + professional headshot"
    contact: "form + email + social links"
  selection_rules:
    - "Only show work you want MORE of"
    - "Every image must earn its place — if you hesitate, cut it"
    - "Quality >>> quantity. 40 great images > 200 okay ones."
    - "First and last images in gallery = strongest. Middle = supporting."
    - "Consistent editing style within each gallery"
    - "Update quarterly — remove weakest, add strongest"
  platforms:
    free: "Adobe Portfolio (with CC), Mylio, Pixieset (limited)"
    paid: "Squarespace ($16/mo), SmugMug ($13/mo), Zenfolio"
    social: "Instagram (discovery), 500px (community), Flickr (archive)"
```

### Portfolio Review Scoring (0-100)

| Dimension | Weight | What to evaluate |
|---|---|---|
| Image quality | 25% | Technical excellence — exposure, focus, sharpness |
| Consistency | 20% | Cohesive editing style, color palette, mood |
| Storytelling | 20% | Each image communicates, series has narrative flow |
| Curation | 15% | Only strongest work, no filler, no near-duplicates |
| Presentation | 10% | Clean layout, proper sizing, fast loading |
| Range within genre | 10% | Shows versatility within your specialty |

**Score < 60:** Major rework needed. **60-80:** Solid, refine edges. **80+:** Professional quality.

---

## Phase 9: Photography Business Fundamentals

### Pricing Framework

```
COST OF DOING BUSINESS (CODB):
  gear_depreciation: "$X/year"
  software: "$X/year (Lightroom, Photoshop, etc.)"
  insurance: "$X/year"
  website_hosting: "$X/year"
  marketing: "$X/year"
  transportation: "$X/year"
  education: "$X/year"
  ─────────────────
  TOTAL ANNUAL COSTS: $______

PRICING FORMULA:
  hours_per_shoot: "shooting + editing + admin + travel"
  desired_annual_income: "$______"
  realistic_shoots_per_year: "______ (don't overestimate)"
  
  minimum_per_shoot = (CODB + desired_income) / shoots_per_year
  
  THEN: Add 20-30% for taxes
  THEN: Round up to psychological price point ($297, $497, $997)
```

### Client Workflow

```
1. INQUIRY → Respond within 4 hours. Send pricing guide PDF.
2. CONSULTATION → 15-30 min call. Understand needs. Send formal quote.
3. BOOKING → Contract signed + 50% deposit. Non-refundable retainer.
4. PRE-SHOOT → Location scout. Shot list. Wardrobe guidance email.
5. SHOOT DAY → Arrive early. Deliver experience, not just photos.
6. EDITING → Deliver in stated timeline (7-14 days typical).
7. DELIVERY → Online gallery with download. Remaining 50% due.
8. FOLLOW-UP → Thank you email. Request testimonial at 1 week. Ask for referral at 1 month.
```

### Contract Must-Haves

- [ ] Scope of work (hours, deliverables, number of edited images)
- [ ] Payment terms (deposit, balance, late fees)
- [ ] Cancellation/rescheduling policy (minimum 48 hours notice)
- [ ] Image usage rights (who owns what, licensing terms)
- [ ] Model release (if applicable)
- [ ] Liability limitations (equipment failure, force majeure)
- [ ] Delivery timeline and format

---

## Phase 10: 12-Month Skill Progression

### Month-by-Month Curriculum

| Month | Focus | Exercise | Deliverable |
|---|---|---|---|
| 1 | Exposure triangle | Shoot same scene at every aperture (f/2.8 → f/16). Compare. | 1 exposure comparison set |
| 2 | Composition | 100 photos using ONLY one composition technique per week | 4 best compositions |
| 3 | Natural light | Golden hour shoot 3× per week. Compare same location at different times. | 10-image light study |
| 4 | Portrait fundamentals | Photograph 5 different people. Practice directing. | 5 portrait edits |
| 5 | Flash basics | Bounce flash in 5 different rooms. Off-camera flash. | Before/after flash comparison |
| 6 | Editing mastery | Develop consistent editing style. Edit same RAW 5 ways. | 3 preset/style recipes |
| 7 | Specialization | Pick ONE genre. Shoot only that for 30 days. | 15-image genre portfolio |
| 8 | Advanced lighting | 2-3 light setups. Practice lighting patterns. | Lighting diagram + results |
| 9 | Storytelling | Photo essay: 10-15 images telling one story | Complete photo essay |
| 10 | Speed & consistency | Simulated event: 2 hours, 500 shots, cull to 50 | Consistent event set |
| 11 | Portfolio building | Curate best 40 images. Build portfolio site. | Live portfolio |
| 12 | First client | Offer free/discounted shoot. Full professional workflow. | Delivered gallery + testimonial |

### Deliberate Practice Protocol

```yaml
practice_session:
  frequency: "minimum 3× per week, 1-2 hours"
  structure:
    warm_up: "10 min — shoot familiar subject with constraints (one lens, one setting)"
    focused_drill: "30-60 min — this month's focus area"
    review: "20 min — cull, rate, identify 3 things to improve next time"
  rules:
    - "Set ONE learning goal per session (not 'take good photos')"
    - "Shoot manual mode — learn the camera, not the auto algorithms"
    - "Review your own work critically — be your harshest critic"
    - "Study one photographer you admire each week — what makes their work work?"
    - "1000 photos analyzed > 100 photos taken casually"
```

---

## Phase 11: Common Mistakes & Fixes

| # | Mistake | Fix |
|---|---|---|
| 1 | Buying gear instead of learning to see | Best camera = the one you have. Master it before upgrading. |
| 2 | Not shooting enough | Volume matters early on. 10,000 photos = start of competence. |
| 3 | Over-editing | If it looks edited, you went too far. Subtle > dramatic. |
| 4 | Not backing up | 3-2-1 rule: 3 copies, 2 different media, 1 offsite. Non-negotiable. |
| 5 | Ignoring light direction | Walk around subject. Move yourself. Light direction > light quantity. |
| 6 | Chimping (checking LCD after every shot) | Trust your settings. Check histogram periodically, not every frame. |
| 7 | No consistent style | Pick a look. Edit everything the same way. Consistency = brand. |
| 8 | Shooting at eye level only | Get low, get high, shoot through things. Unusual angles = interesting photos. |
| 9 | Not printing work | Screens lie. Print your best work. See it at size. It changes everything. |
| 10 | Comparing to others' highlights | Compare to your own work 6 months ago. That's the only benchmark that matters. |

---

## Phase 12: Advanced Techniques

### Long Exposure

```
Gear: Tripod + ND filter (6 or 10 stop) + remote shutter
Settings: f/8-11, ISO 100, Bulb mode
Timer: ND6 → multiply normal exposure × 64. ND10 → multiply × 1024.

ND FILTER EXPOSURE TABLE:
| Normal exposure | ND6 (6-stop) | ND10 (10-stop) |
|---|---|---|
| 1/250 | 1/4 | 4 sec |
| 1/125 | 1/2 | 8 sec |
| 1/60 | 1 sec | 16 sec |
| 1/30 | 2 sec | 32 sec |
| 1/15 | 4 sec | 60 sec |
```

### Focus Stacking (Macro/Landscape)

```
1. Tripod mandatory. Manual focus.
2. Focus on nearest point. Take shot.
3. Move focus slightly deeper. Take shot.
4. Repeat until entire depth is covered (5-20 shots typical).
5. Stack in Photoshop (Auto-Align + Auto-Blend) or Helicon Focus.
Result: Razor-sharp from front to back at any aperture.
```

### HDR (High Dynamic Range)

```
1. Tripod. Manual mode. Manual focus.
2. Meter for midtones. Take shot.
3. Underexpose -2 stops. Take shot.
4. Overexpose +2 stops. Take shot.
5. (Optional: -1 and +1 for smoother blend = 5 brackets)
6. Merge in Lightroom or Photomatix.
Rule: Natural-looking HDR only. If it looks "HDR-y", pull it back.
```

### Astrophotography Basics

```
THE 500 RULE: Max shutter = 500 / (focal length × crop factor)
Example: 24mm on full frame = 500/24 = 20 seconds max before star trails

Settings: f/2.8 or wider, ISO 3200-6400, manual focus on bright star (magnify + adjust)
Lens: widest and fastest you own (14mm f/2.8 ideal)
Planning: Clear sky, no moon (new moon best), dark sky location (Bortle 1-4)
Apps: PhotoPills, Stellarium, Clear Outside
```

---

## Natural Language Commands

| Command | Action |
|---|---|
| `/photo-check` | Run the 8-dimension quick health assessment |
| `Review my portfolio` | Score portfolio across 6 dimensions with specific improvement actions |
| `Settings for [genre]` | Provide camera settings, gear, and workflow for that genre |
| `Help me light this` | Lighting setup guide based on description of scene/subject |
| `Critique this photo` | Technical + compositional analysis with specific fixes |
| `What lens should I buy next?` | Personalized recommendation based on current gear and goals |
| `Plan a shoot for [event/subject]` | Complete pre-shoot checklist with shot list |
| `Edit this style` | Color grading recipe to achieve described look |
| `Price my photography` | CODB calculation and pricing framework |
| `Teach me [technique]` | Step-by-step guide with practice exercises |
| `Build my portfolio` | Architecture, selection rules, and platform recommendation |
| `Monthly practice plan` | This month's focus area with daily exercises |

---

## Edge Cases

### Shooting in Harsh Conditions
- **Rain:** Plastic bag + rubber band = camera rain cover. Shoot reflections. Embrace mood.
- **Extreme cold:** Keep batteries in pocket (warm). Bag camera when returning to warm room (condensation).
- **Extreme heat:** Don't leave gear in car. Sensor heat noise increases. Shoot earlier/later.
- **Sand/dust:** Change lenses in sheltered spot. Clean sensor after. Ziplock bags for protection.
- **Underwater:** Dedicated housing only. No DIY. Rent before buying.

### Phone Photography (When It's All You Have)
- Clean the lens (fingerprints = haze)
- Tap to focus, hold to lock exposure
- Shoot in 2× or 3× optical (not digital zoom)
- Use portrait mode for bokeh (verify edge detection)
- Edit in Lightroom Mobile or Snapseed (free, powerful)
- All composition and light rules still apply — they're about seeing, not gear

### AI in Photography (Current State)
- **Useful:** Noise reduction (Topaz, DxO), sky replacement, object removal, upscaling
- **Controversial:** AI-generated composites presented as photos
- **Rule of thumb:** AI as editing tool = fine. AI replacing the photograph = not photography.
- **Competitions:** Most ban AI-generated images. Check rules.

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI agents that actually work.*
