# 📸 Photography Mastery by AfrexAI

Complete photography system — from auto mode to professional-quality images. Covers exposure, composition, lighting, 6 genre workflows, editing, gear selection, portfolio building, business fundamentals, and a 12-month skill progression curriculum.

## Install

```bash
clawhub install afrexai-photography-mastery
```

## What's Inside

- **8-dimension skill assessment** with scoring and progression path
- **Exposure triangle** with decision tables for ISO, aperture, shutter by situation
- **12 composition techniques** beyond rule of thirds with mistake fixes
- **Complete lighting guide** — natural light, window setups, flash, 5 portrait patterns
- **6 genre workflows** with full YAML checklists: Portrait, Landscape, Street, Product, Real Estate, Wedding/Event
- **Post-processing pipeline** — RAW workflow, color grading recipes, retouching ethics
- **Gear selection** — camera decision matrix, lens priority order, essential accessories
- **Portfolio architecture** with 6-dimension scoring rubric
- **Photography business** — pricing formula, client workflow, contract checklist
- **12-month curriculum** with monthly exercises and deliverables
- **Advanced techniques** — long exposure, focus stacking, HDR, astrophotography
- **Edge cases** — harsh conditions, phone photography, AI tools

## Quick Start

Ask your agent:
- "Settings for portrait photography"
- "Help me light this scene"
- "What lens should I buy next?"
- "Build my portfolio"
- "Price my photography"

## ⚡ Level Up

Want industry-specific visual content strategies? Check out our **Context Packs** ($47 each) — deep frameworks for [Real Estate](https://afrexai-cto.github.io/context-packs/), [Ecommerce](https://afrexai-cto.github.io/context-packs/), [Healthcare](https://afrexai-cto.github.io/context-packs/), and more.

## 🔗 More Free Skills by AfrexAI

- [afrexai-social-media-engine](https://clawhub.com/skills/afrexai-social-media-engine) — Content strategy for every platform
- [afrexai-brand-strategy](https://clawhub.com/skills/afrexai-brand-strategy) — Visual identity and brand positioning
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO-optimized content creation
- [afrexai-product-launch](https://clawhub.com/skills/afrexai-product-launch) — Launch strategy and execution
- [afrexai-conversion-copywriting](https://clawhub.com/skills/afrexai-conversion-copywriting) — Copy that converts

👉 **Browse all skills:** [AfrexAI Storefront](https://afrexai-cto.github.io/context-packs/)

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛*
