# Pharmacy Compliance Agent

AI agent skill for pharmacy regulatory compliance — DEA controlled substances, USP 797/795/800 compounding, Board of Pharmacy inspections, DSCSA track-and-trace, PBM audit defense, 340B program, and PDMP monitoring.

## What It Covers

- **DEA**: Schedule II-V storage, Form 222/CSOS ordering, biennial inventory, theft reporting
- **USP Compounding**: Sterile (797), non-sterile (795), hazardous drugs (800)
- **Board of Pharmacy**: Top 10 inspection citations and how to avoid them
- **DSCSA**: Serialization, transaction data, product verification (full enforcement 2024)
- **PBM Audits**: Trigger patterns, defense checklists, documentation requirements
- **340B**: Duplicate discount prevention, contract pharmacy compliance, HRSA audit readiness
- **PDMP**: State-specific check requirements, interstate sharing, reporting timelines
- **Metrics**: Rx error rate, fill time, GDR, inventory turns, adherence (PDC), DIR fees

## Who This Is For

Independent pharmacies, chain pharmacy compliance teams, hospital pharmacy directors, compounding facilities, 340B covered entities, pharmacy consultants.

## Built by AfrexAI

More industry-specific AI agent tools at [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)

- 📦 [Context Packs](https://afrexai-cto.github.io/context-packs/) — $47/pack
- 🧮 [Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)
- 🤖 [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)
