# AfrexAI Personal Finance Mastery

Complete personal finance system — budgeting, debt payoff, investing, tax optimization, net worth tracking, and financial independence planning.

## Install

```bash
clawhub install afrexai-personal-finance
```

## What You Get

- **Net worth tracking** with monthly snapshots and trend analysis
- **50/30/20 budgeting** with reverse budgeting for simplicity
- **Debt elimination** — avalanche, snowball, and hybrid strategies with the crossover rule
- **Investment priority order** — exact sequence from 401(k) match to taxable brokerage
- **Tax optimization** — every tax-advantaged account explained with limits and strategies
- **Financial independence planning** — FI number calculator, savings rate → years table, withdrawal strategies
- **Insurance & estate essentials** — coverage checklist, life insurance decision tree, estate documents
- **0-100 financial health scoring** across 8 dimensions
- **Agent automation** — daily transaction categorization, weekly summaries, monthly reviews, quarterly rebalancing

## Quick Start

1. Run `/finance-check` for your 8-signal health score
2. Build your net worth statement
3. Set up 50/30/20 budget (or reverse budget)
4. Follow the investment priority order
5. Schedule monthly reviews

## Who This Is For

- Anyone managing personal money — any income level, any country
- People paying off debt who need a clear strategy
- New investors who want a simple, proven approach
- Anyone pursuing financial independence (FIRE)
- Couples building joint financial plans

Zero dependencies. Works with any agent. Pure methodology.

---

⚡ **Level up your financial operations:**

| Pack | Best For | Link |
|------|----------|------|
| **Fintech Context Pack** | Building financial products | [$47](https://afrexai-cto.github.io/context-packs/) |
| **SaaS Context Pack** | Subscription business finances | [$47](https://afrexai-cto.github.io/context-packs/) |
| **Professional Services Pack** | Service business financial planning | [$47](https://afrexai-cto.github.io/context-packs/) |

🔗 **More free skills by AfrexAI:**
- [afrexai-budget-tracker](https://clawhub.com/skills/afrexai-budget-tracker) — Business budget and expense management
- [afrexai-investment-engine](https://clawhub.com/skills/afrexai-investment-engine) — Stock, crypto & portfolio analysis
- [afrexai-fpa-engine](https://clawhub.com/skills/afrexai-fpa-engine) — Financial planning & analysis for businesses
- [afrexai-founder-os](https://clawhub.com/skills/afrexai-founder-os) — Startup operating system
- [afrexai-strategic-thinking](https://clawhub.com/skills/afrexai-strategic-thinking) — Mental models & decision frameworks

🛒 **Browse all AfrexAI context packs:** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
