# AfrexAI Performance Review Engine 🖤💛

The complete AI-powered performance management system. Write better reviews, run calibration sessions, collect 360° feedback, and develop your people — all through your AI agent.

## What This Does

- **Self-assessments** using STAR-I framework (not vague bullet points)
- **Manager reviews** using the OBSERVE method with templates for every rating level
- **360° feedback** collection, anonymization, and synthesis
- **Calibration sessions** with bias checklists and discussion frameworks
- **Development plans** using the 70-20-10 model
- **Continuous feedback** with SBI formula and monthly check-in templates
- **Performance scoring** — weighted competency scores (0-100) and team dashboards
- **Edge cases** — new hires, role changes, remote workers, inherited teams, difficult conversations

## Install

```bash
clawhub install afrexai-performance-review
```

## Quick Start

```
"Write a performance review for Sarah — she exceeded on delivery and technical work, 
but needs to improve cross-functional communication. Rating: 4/5."

"Help me write my self-assessment. Key achievements: led API migration (12 services, 
2 weeks early), mentored 2 junior devs, reduced incident response time by 40%."

"Prepare calibration cards for my 5 direct reports."
```

## What's Inside

| Section | What You Get |
|---------|-------------|
| Cycle Setup | Full YAML config template with timeline, competencies, rating scale |
| Self-Assessment | STAR-I method, prompts by competency, quality checklist |
| Manager Reviews | OBSERVE framework, templates for ratings 1-5, writing rules |
| 360° Feedback | Request templates, synthesis method, theme extraction |
| Calibration | Prep cards, discussion framework, 7-point bias checklist |
| Delivery | Conversation structure, scripts for difficult situations |
| Development | 70-20-10 plans, career goal templates, support mapping |
| Continuous | Monthly check-in template, SBI feedback formula |
| Scoring | Weighted performance scores, team health dashboard |
| Edge Cases | New hires, role changes, remote, inherited teams, legal notes |

## ⚡ Level Up Your HR & People Operations

This free skill covers performance reviews. For a **complete recruitment and people management system** — including sourcing, screening, interviewing, offer negotiation, onboarding, and retention:

👉 [**AfrexAI Recruitment Context Pack — $47**](https://afrexai-cto.github.io/context-packs/)

45+ files of battle-tested frameworks that turn your AI agent into a full HR department.

## 🔗 More Free Skills by AfrexAI

- **[afrexai-recruiting-engine](https://clawhub.com/skills/afrexai-recruiting-engine)** — Full recruiting pipeline from sourcing to offer
- **[afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter)** — ICP-based lead generation with scoring
- **[afrexai-meeting-mastery](https://clawhub.com/skills/afrexai-meeting-mastery)** — Meeting prep, follow-up, and ROI tracking
- **[afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support)** — Ticket triage, CSAT, churn prevention
- **[afrexai-business-automation](https://clawhub.com/skills/afrexai-business-automation)** — Workflow design and process automation

📦 **Browse all AfrexAI skills & context packs:** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
