# AfrexAI Performance Engineering 🖤💛

Complete performance engineering system for your AI agent — from "it's slow" to "here's why and here's the fix."

## What This Skill Does

Turns your agent into a performance engineering expert that can:

- **Diagnose** slow applications with structured investigation briefs
- **Profile** CPU, memory, and I/O across Node.js, Python, Go, and Java
- **Optimize** algorithms, queries, caching, and concurrency patterns
- **Load test** APIs with k6 templates and results interpretation
- **Plan capacity** with growth projections and cost-performance analysis
- **Prevent regressions** with CI/CD performance gates
- **Score** your system's performance maturity (0-100)

## Install

```bash
clawhub install afrexai-performance-engineering
```

## Quick Start

Tell your agent:
- "Why is this endpoint slow?" → Full investigation + profiling
- "Load test the API" → k6 test design and execution
- "Optimize this query" → EXPLAIN ANALYZE + index recommendations
- "Score our performance" → 100-point maturity assessment

## What's Inside

- **Performance Budget Framework** — target metrics by app type
- **Profiling Decision Tree** — CPU, I/O, memory, or concurrency?
- **Language-specific profilers** — Node.js, Python, Go, Java with code examples
- **Flame graph interpretation** — what to look for, action rules
- **Optimization patterns** — algorithm fixes, caching matrix, N+1 detection, connection pools
- **Database performance** — EXPLAIN ANALYZE guide, index strategy, query checklist
- **Load testing** — k6 templates, results analysis, bottleneck identification
- **Frontend performance** — Core Web Vitals fixes, bundle optimization
- **Capacity planning** — growth models, cost-performance ROI calculation
- **CI/CD gates** — automated regression detection
- **100-point scoring rubric** — measurement, prevention, optimization, operations

## ⚡ Level Up

This skill covers the methodology. For industry-specific performance patterns and production architectures:

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — SaaS-specific scaling and multi-tenant performance
- **[Fintech Context Pack](https://afrexai-cto.github.io/context-packs/)** — Low-latency trading and financial data pipelines
- **[Healthcare Context Pack](https://afrexai-cto.github.io/context-packs/)** — HIPAA-compliant infrastructure optimization

## 🔗 More Free Skills by AfrexAI

- [`afrexai-code-reviewer`](https://clawhub.com/skill/afrexai-code-reviewer) — SPEAR code review framework
- [`afrexai-devops-engine`](https://clawhub.com/skill/afrexai-devops-engine) — Complete DevOps & platform engineering
- [`afrexai-api-architect`](https://clawhub.com/skill/afrexai-api-architect) — API design, security, and lifecycle
- [`afrexai-database-engineer`](https://clawhub.com/skill/afrexai-database-engineer) — Schema design, queries, migrations
- [`afrexai-technical-docs`](https://clawhub.com/skill/afrexai-technical-docs) — Documentation system

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**

---
Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
