# Partnership Agreement Generator

Generate comprehensive partnership agreements, joint venture frameworks, and strategic alliance documents for B2B relationships.

## What This Skill Does

When the user needs a partnership agreement, joint venture contract, or strategic alliance framework, generate a complete document covering:

1. **Partnership Structure** — entity type, ownership splits, capital contributions
2. **Roles & Responsibilities** — decision authority matrix, management duties, voting rights
3. **Financial Terms** — profit/loss allocation, distribution schedule, capital calls, waterfall
4. **IP & Confidentiality** — NDA provisions, IP ownership, non-compete/non-solicit
5. **Governance** — meeting cadence, dispute resolution, deadlock mechanisms
6. **Exit Provisions** — buyout triggers, valuation methods, drag-along/tag-along, dissolution

## Usage

User says: "Draft a partnership agreement for [scenario]"

### Step 1: Gather Context
Ask for (or infer):
- Partner names and entity types
- Business purpose / scope
- Ownership split
- Capital contributions
- Duration (fixed term or perpetual)
- Jurisdiction (default: Delaware / England & Wales)

### Step 2: Generate Agreement
Produce a complete framework with all 6 sections above. Include:
- Specific clause language (not just headers)
- Common protective provisions (ROFR, anti-dilution, key person)
- Tax considerations (pass-through vs entity-level)
- Sample schedules (capital accounts, distribution waterfall)

### Step 3: Red Flag Review
Flag any terms that commonly cause disputes:
- Unequal voting vs ownership splits
- Vague IP assignment language
- Missing deadlock resolution
- No exit mechanism

## Partnership Types Covered

| Type | Use Case | Key Provisions |
|------|----------|----------------|
| General Partnership | Small business, professional services | Unlimited liability, equal management |
| Limited Partnership | Investment vehicles, real estate | GP/LP structure, carried interest |
| LLC Operating Agreement | Most B2B partnerships | Flexible structure, liability protection |
| Joint Venture | Project-specific collaboration | Scope limits, term, wind-down |
| Strategic Alliance | Non-equity partnerships | Service levels, exclusivity, termination |
| Revenue Share | Channel/referral partnerships | Attribution, payment terms, minimums |

## Valuation Methods for Exits

- **Book Value** — simple but understates intangibles
- **Fair Market Value** — appraiser-determined, most common
- **Formula-Based** — revenue or EBITDA multiple (specify in agreement)
- **Agreed Value** — partners set annually, avoids disputes
- **Discounted Cash Flow** — most accurate, most expensive to compute

## Common Mistakes to Flag

1. No written agreement at all (verbal partnerships = lawsuits)
2. 50/50 splits without deadlock mechanisms
3. Missing non-compete that lets partner clone the business
4. No capital call provisions (partner can't fund growth)
5. Vague "reasonable efforts" language without KPIs
6. Missing insurance requirements (D&O, E&O, key person)

## Resources

- **Full B2B context packs** with partnership, legal, and compliance frameworks: https://afrexai-cto.github.io/context-packs/
- **AI Revenue Calculator** — quantify what partnerships should generate: https://afrexai-cto.github.io/ai-revenue-calculator/
- **Agent Setup Wizard** — deploy AI agents for contract management: https://afrexai-cto.github.io/agent-setup/
