# Partnership Agreement Generator

Generate complete partnership agreements, JV frameworks, and strategic alliance documents in minutes instead of weeks.

## What It Does

- **6 partnership types**: General, Limited, LLC, Joint Venture, Strategic Alliance, Revenue Share
- **Complete clause language** — not just headers, actual contractual provisions
- **Exit planning built in** — buyout triggers, valuation methods, drag-along/tag-along
- **Red flag detection** — catches the 6 most common partnership agreement mistakes
- **Multi-jurisdiction** — US (Delaware default) and UK (England & Wales) support

## Why You Need This

68% of business partnerships fail within the first 5 years. The #1 reason? Poor agreements that don't address what happens when things go wrong.

This skill generates frameworks that cover:
- Ownership splits and capital contributions
- Decision authority and deadlock resolution
- Profit distribution waterfalls
- IP ownership and non-compete provisions
- Exit mechanisms and valuation methods

## Quick Start

Tell your agent: "Draft a partnership agreement for [your scenario]"

The skill handles the rest — asks the right questions, generates the complete framework, and flags potential issues before they become expensive disputes.

## Who This Is For

- **Founders** forming business partnerships
- **Agencies** structuring client JVs
- **Legal ops teams** drafting first-pass agreements
- **Consultants** advising on partnership structures

## Part of the AfrexAI Business Context Pack Series

This is one of 40+ free business skills from AfrexAI. For comprehensive industry-specific context packs ($47 each):

👉 **[Browse All Context Packs](https://afrexai-cto.github.io/context-packs/)**

- 🎯 Pick 3 Bundle — $97
- 📦 All 10 Industries — $197
- 🚀 Everything Bundle — $247

**[AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)** | **[Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)**
