# OKR & Strategy Execution Engine

Complete OKR methodology — from company vision to weekly execution. Built for founders, team leads, and operators who want goal-setting that actually drives results.

## What This Skill Does

Gives your AI agent a complete strategy execution framework:
- **Annual planning** with vision → pillars → goals hierarchy
- **OKR writing** with quality rubrics, anti-patterns, and YAML templates
- **Alignment cascading** from company → team → individual
- **KPI dashboards** with health/growth/quality/velocity metrics
- **Review cadences** — weekly, monthly, quarterly rituals with agendas
- **Scoring & accountability** — honest grading culture, not bureaucracy
- **5 ready scenarios** — first-time OKRs, solo founder, mid-quarter pivot, remote teams, performance reviews

## Install

```bash
clawhub install afrexai-okr-engine
```

## Quick Start

Tell your agent:
- "Set OKRs for Q2" — generates structured OKR template with scoring
- "Grade this OKR" — runs 7-dimension quality rubric (0-100)
- "Run quarterly planning" — full retro + planning ritual agenda
- "Create KPI dashboard" — health/growth/quality metrics YAML
- "Weekly OKR update" — confidence tracking template

## What Makes This Different

The existing OKR skill on ClawHub is a 6KB solopreneur guide. This is a 30KB complete system covering:
- North star metric selection by business type
- Strategic pillar architecture
- OKR quality checklist (every KR must pass 7 tests)
- Scoring methodology (0.0-1.0) with healthy range benchmarks
- Alignment maps with cross-team dependency contracts
- 4 review cadence templates with exact agendas
- Advanced patterns: stretch vs committed, leading indicators, Agile integration
- Works for solo founders AND 50+ person organizations

## ⚡ Level Up

Want a complete business operating system for your vertical?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)**

Industry-specific agent configurations with OKR templates, KPIs, and playbooks tailored to your business:
- SaaS metrics + growth OKRs
- Professional Services utilization + delivery OKRs
- Manufacturing efficiency + quality OKRs
- And 7 more verticals

## 🔗 More Free Skills by AfrexAI

- [afrexai-founder-os](https://clawhub.com/skills/afrexai-founder-os) — Complete startup operating system
- [afrexai-sales-playbook](https://clawhub.com/skills/afrexai-sales-playbook) — B2B sales methodology
- [afrexai-pricing-strategy](https://clawhub.com/skills/afrexai-pricing-strategy) — Value-based pricing framework
- [afrexai-customer-success](https://clawhub.com/skills/afrexai-customer-success) — Retention & expansion engine
- [afrexai-fpa-engine](https://clawhub.com/skills/afrexai-fpa-engine) — Financial planning & analysis

**Browse all AfrexAI skills:** [clawhub.com/publishers/afrexai-cto](https://clawhub.com/publishers/afrexai-cto)
