# Employee Offboarding Manager

Generate complete offboarding checklists and transition plans when an employee leaves.

## Usage

Tell the agent who's leaving, their role, department, and last day. It produces:

1. **IT & Access Revocation Checklist** — accounts, devices, badges, VPN, cloud services
2. **Knowledge Transfer Plan** — critical docs, ongoing projects, key contacts, handover meetings
3. **HR & Compliance Checklist** — final paycheck, benefits termination, NDA reminders, exit interview
4. **Manager Transition Plan** — interim coverage, hiring timeline, team communication
5. **Timeline** — day-by-day schedule from notice to last day

## Example

```
Offboard: Sarah Chen, Senior Product Manager, Product team. Last day: March 15.
She owns the Q2 roadmap, runs weekly stakeholder syncs, and has admin access to Jira, Figma, and Amplitude.
```

The agent returns a full offboarding package with nothing missed.

## Why This Matters

Botched offboarding costs companies $50K+ per incident — lost knowledge, dangling access (security risk), compliance gaps, and team disruption. Most companies use a spreadsheet someone made in 2019.

## Works With

Any AI agent platform. No API keys needed — pure context skill.

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI context packs for business teams.

Get the full **Professional Services Context Pack** ($47) for HR, operations, and compliance automation: https://afrexai-cto.github.io/context-packs/

Calculate what bad processes cost your company: https://afrexai-cto.github.io/ai-revenue-calculator/
