# AfrexAI Observability Engine 🔭

Complete observability & reliability engineering system for AI agents. Covers structured logging, metrics, distributed tracing, SLOs, alerting, incident response, post-mortems, on-call, chaos engineering, and cost optimization.

## Install

```bash
clawhub install afrexai-observability-engine
```

## What's Inside

A 12-phase system covering the full observability lifecycle:

1. **Structured Logging** — JSON schema, PII scrubbing, log level decision tree, setup by language (Node/Python/Go)
2. **Metrics Collection** — RED + USE methods, naming conventions, label design, instrumentation checklist
3. **Distributed Tracing** — OpenTelemetry setup, sampling strategies, context propagation
4. **SLOs & Error Budgets** — SLI selection, target setting, burn-rate alerts, weekly tracking
5. **Alert Design** — Severity levels, anti-patterns, Prometheus templates, runbook templates
6. **Dashboard Architecture** — 4-level hierarchy (executive → infrastructure), panel specs
7. **Incident Response** — Severity classification, roles, step-by-step workflow, channel templates
8. **Post-Mortem Framework** — Blameless template, 5 Whys, meeting agenda
9. **On-Call Operations** — Rotation design, health metrics, weekly review
10. **Chaos Engineering** — Experiment templates, maturity levels, abort conditions
11. **Cost Optimization** — Cost driver ranking, reduction checklist, monthly review
12. **Advanced Patterns** — Correlation, synthetic monitoring, feature flag observability, maturity model

Plus: /16 health check, 100-point quality rubric, 10 commandments, 12 natural language commands.

## Quick Start

Tell your agent:
> "Audit our observability posture"

Or:
> "Design SLOs for our payment API"

## ⚡ Level Up

For industry-specific observability patterns, check out [AfrexAI Context Packs ($47)](https://afrexai-cto.github.io/context-packs/) — SaaS, Fintech, Healthcare, and 7 more verticals.

### More Free Skills by AfrexAI

- `afrexai-devops-engine` — CI/CD, infrastructure, deployment
- `afrexai-api-architect` — API design and security
- `afrexai-database-engineering` — Schema, queries, migrations
- `afrexai-code-reviewer` — Code review with SPEAR framework
- `afrexai-prompt-engineering` — Prompt design and testing

**Browse all:** [clawhub.com](https://clawhub.com) | [Storefront](https://afrexai-cto.github.io/context-packs/)
