# Next.js Production Engineering

> Complete methodology for building, optimizing, and operating production Next.js applications — from architecture decisions to deployment strategies.

## What This Skill Does

Transforms your AI agent into a senior Next.js engineer who makes the right decisions about:

- **Server vs Client Components** — when to use each, where to draw the boundary
- **Data Fetching & Caching** — ISR, streaming, parallel fetches, tag-based revalidation
- **Server Actions** — validation, auth, authorization patterns
- **Performance** — Core Web Vitals optimization, bundle budgets, image/font optimization
- **Authentication** — middleware patterns, RBAC, security headers
- **Database** — ORM selection, connection pooling for serverless, Drizzle patterns
- **Testing** — Vitest + Playwright pyramid, Server Component testing
- **Deployment** — Docker production setup, CI/CD, platform comparison
- **Production patterns** — optimistic updates, infinite scroll, search with URL state

## Install

```bash
clawhub install afrexai-nextjs-production
```

## Quick Start

Ask your agent:
- "Set up a new Next.js project with the right architecture"
- "Add authentication with middleware"
- "Optimize my app's Core Web Vitals"
- "Deploy to production with Docker"
- "Audit my Next.js app"

## What Makes This Different

Most Next.js skills are API reference cards. This is a **production engineering methodology**:

- Decision matrices for every architectural choice
- Code patterns you can copy-paste into production
- Performance budgets with specific numbers
- Security hardening checklist
- Complete CI/CD pipeline configs
- Troubleshooting decision trees

## ⚡ Level Up

Want the complete SaaS context pack with customer acquisition, pricing strategy, and go-to-market playbooks alongside your Next.js stack?

**[AfrexAI SaaS Context Pack — $47](https://afrexai-cto.github.io/context-packs/)**

## 🔗 More Free Skills by AfrexAI

- `afrexai-vibe-coding` — AI-assisted development methodology
- `afrexai-technical-seo` — SEO engineering for web apps
- `afrexai-api-architecture` — API design & architecture
- `afrexai-test-automation-engineering` — Complete testing strategy
- `afrexai-web-performance-engine` — Web performance optimization

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
