# n8n Workflow Mastery

The definitive agent skill for designing, building, debugging, and scaling n8n automations. Goes far beyond API wrappers — this is a complete methodology.

## Install

```bash
clawhub install afrexai-n8n-mastery
```

## What You Get

- **Quick health check** — score your n8n setup in 60 seconds (/10)
- **Workflow architecture** — naming conventions, complexity tiers, layout patterns
- **15+ trigger patterns** — webhook security, schedule patterns, polling with dedup
- **Code node library** — map, filter, dedupe, paginate, rate limit (copy-paste ready)
- **Error handling architecture** — error triggers, retry with backoff, circuit breakers, dead letter queues
- **6 integration patterns** — CRM sync, email pipeline, approval flows, AI classification
- **Sub-workflow design** — when to extract, interface contracts, orchestrator pattern
- **State management** — static data patterns, dedup caches, external state
- **Security checklist** — HMAC verification, credential management, PII handling
- **Performance optimization** — 8-priority stack, batch templates, memory optimization
- **Testing methodology** — unit/integration/smoke/load testing for workflows
- **4 complete workflow templates** — lead capture, report generator, AI ticket classifier, payment sync
- **Advanced patterns** — fan-out/fan-in, event-driven, feature flags, queue pattern
- **100-point quality rubric** — score any workflow across 8 dimensions
- **12 natural language commands** — just describe what you need

Zero dependencies. Works with any n8n instance (self-hosted or cloud).

## Quick Start

Tell your agent:
> "Build an n8n workflow that captures form submissions, enriches leads, adds to HubSpot, and alerts sales on Slack"

The skill provides complete, production-ready workflow designs — not placeholder nodes.

## ⚡ Level Up

Need industry-specific automation playbooks? Check out our context packs:

- **SaaS Context Pack** ($47) — Complete SaaS automation: onboarding, billing, churn prevention
- **Professional Services Pack** ($47) — Client management, proposals, invoicing automation
- **Ecommerce Pack** ($47) — Order processing, inventory, customer engagement automation

👉 **[Browse all 10 packs](https://afrexai-cto.github.io/context-packs/)**

## 🔗 More Free Skills by AfrexAI

- [afrexai-business-automation](https://clawhub.com/skills/afrexai-business-automation) — General automation methodology
- [afrexai-api-architect](https://clawhub.com/skills/afrexai-api-architect) — API design & lifecycle
- [afrexai-devops-engine](https://clawhub.com/skills/afrexai-devops-engine) — CI/CD & platform engineering
- [afrexai-data-analyst](https://clawhub.com/skills/afrexai-data-analyst) — Data analysis frameworks
- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Lead generation system

Built with 🖤💛 by [AfrexAI](https://afrexai-cto.github.io/context-packs/)
