# Moving Company Operations

Complete operations assistant for residential and commercial moving companies. Covers pricing, DOT/FMCSA compliance, crew management, claims handling, and growth strategy.

## What This Skill Does

When activated, the agent becomes a moving company operations expert that can:

- **Price any move** — local, long-distance, commercial, specialty items with seasonal adjustments
- **DOT/FMCSA compliance** — registration requirements, insurance minimums, penalty schedules, Hours of Service
- **Crew management** — compensation benchmarks, productivity targets, utilization tracking
- **Claims handling** — valuation options, FMCSA-mandated timelines, dispute resolution
- **Revenue optimization** — KPI benchmarks, marketing ROI by channel, growth playbook $0 to $1M
- **Document prep** — Bill of Lading requirements, estimate formats, inventory sheets, rights booklets

## Pricing Reference

### Local Moves
- Studio/1BR: $400-800 (2-person crew, 3-5 hrs)
- 3BR: $1,200-2,500 (3-4 person crew, 5-8 hrs)
- 4BR+: $2,000-4,000 (4+ person crew, 6-10 hrs)
- Hourly rate: $80-120/hr per crew

### Long-Distance
- Average: $2,500-7,500 based on weight + distance + season
- Range: $1,800-15,000

### Seasonal Multipliers
- Peak (May-Sep): 1.25-1.50x
- End of month: 1.15-1.25x
- Weekends: 1.10-1.20x
- Off-peak (Oct-Mar): 0.85-1.00x

## DOT/FMCSA Requirements (Interstate)

### Registrations
- USDOT Number (mandatory >10,001 lbs or interstate)
- MC Number (interstate household goods)
- BOC-3 process agent designation
- Biennial Update (every 2 years)
- UCR annual registration ($176-$73,346 by fleet size)

### Insurance Minimums
- Cargo: $5,000/shipment minimum
- Public liability <10K lbs: $300,000
- Public liability >10K lbs: $750,000
- Workers' comp: state-mandated

### Key Penalties
- Operating without authority: up to $10,000/day
- Insurance failure: up to $16,000
- HOS violation: up to $16,000/violation
- Hostage loads: up to $10,000/day

## Crew Benchmarks

| Role | Hourly | Annual |
|------|--------|--------|
| Helper | $14-18 | $29-37K |
| Driver/Mover | $18-25 | $37-52K |
| Crew Lead | $22-30 | $46-62K |
| Estimator/Sales | — | $45-65K + 3-8% commission |

### Productivity Targets
- 400-600 lbs moved per labor hour
- $1,200-2,500 revenue per truck per day
- 1.5-2.5 jobs per crew per day (local)
- <2% damage claims rate
- 75-85% crew utilization

## Claims & Valuation

1. **Released Value** — $0.60/lb per article (free, default)
2. **Full Value Protection** — replacement value, $0-500 deductible, 0.5-1.5% of declared value
3. **Third-party insurance** — mover must inform of option

Timeline: Customer files within 9 months → Mover acknowledges in 30 days → Settlement offer within 120 days

## Revenue Benchmarks

- Gross margin: 35-50% (top: 55%+)
- Net profit: 8-15% (top: 18-22%)
- Revenue per truck/year: $180-350K (top: $400K+)
- Customer acquisition cost: $150-400
- Repeat/referral rate: 30-40% (top: 55%+)

## Growth Playbook

1. **Startup ($0-100K)**: 1-2 trucks, local, Google Business Profile
2. **Growth ($100-300K)**: 3-5 trucks, CRM + dispatch software
3. **Scale ($300K-700K)**: Interstate authority, fleet management, sales
4. **Mature ($700K-1M+)**: Commercial contracts, storage, expand

## Need More?

Full industry context packs with AI-ready configs: https://afrexai-cto.github.io/context-packs/
