# ML & AI Engineering System by AfrexAI ⚡

Complete methodology for building, deploying, and operating production ML/AI systems — from problem framing to monitoring at scale.

## What This Does

Gives your AI agent a complete ML engineering playbook:

- **Problem framing** — ML vs rules decision, problem brief template, kill criteria
- **Data engineering** — Quality scoring, feature engineering patterns, leakage prevention
- **Experiment management** — Model selection guide, hyperparameter tuning, tracking templates
- **Model evaluation** — Metric selection by task, evaluation rigor checklist, offline-to-online gap analysis
- **Deployment** — Pattern decision tree, serving config, A/B testing for models
- **LLM engineering** — RAG architecture, model selection, cost optimization strategies
- **Monitoring** — Drift detection, automated retraining pipeline, response playbooks
- **MLOps** — CI/CD for ML, model registry workflow, platform components
- **Responsible AI** — Bias detection, model cards, fairness metrics
- **Cost optimization** — GPU selection, inference optimization, cost tracking

## Install

```bash
clawhub install afrexai-ml-engineering
```

## Quick Start

Tell your agent: "Frame an ML problem for predicting customer churn" — it will use the problem brief template, help you decide ML vs rules, and guide you through data assessment.

## Example Commands

- "Frame ML problem" — structured problem definition
- "Build RAG system" — full retrieval-augmented generation architecture
- "Deploy model" — serving config with autoscaling
- "Set up monitoring" — drift detection + auto-retraining
- "Score ML system" — 100-point quality rubric

## ⚡ Level Up

Want industry-specific ML applications with vertical-tuned prompts, evaluation frameworks, and deployment patterns?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)**

- **Fintech Pack** — Fraud detection, credit scoring, risk models
- **Healthcare Pack** — Clinical NLP, diagnostic AI, patient risk
- **SaaS Pack** — Churn prediction, usage analytics, recommendation engines

## 🔗 More Free Skills by AfrexAI

- [afrexai-data-analyst](https://clawhub.com/afrexai-cto/afrexai-data-analyst) — Data analysis methodology
- [afrexai-data-engineering](https://clawhub.com/afrexai-cto/afrexai-data-engineering) — Data pipelines & modeling
- [afrexai-api-architect](https://clawhub.com/afrexai-cto/afrexai-api-architect) — API design & lifecycle
- [afrexai-system-architect](https://clawhub.com/afrexai-cto/afrexai-system-architect) — System architecture
- [afrexai-prompt-engineering](https://clawhub.com/afrexai-cto/afrexai-prompt-engineering) — Prompt design

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
