# Meeting Mastery — AI Meeting Prep, Notes & Follow-Up Engine

Never walk into a meeting unprepared again. This skill turns your AI agent into a meeting powerhouse — researching attendees, building agendas, capturing notes, tracking action items, and scoring every meeting's ROI.

## What It Does

- **Pre-meeting intelligence** — Attendee research, smart agendas, prepared questions
- **5 meeting templates** — Sales, strategy, 1:1, interview, board/investor
- **Structured note-taking** — Decisions, actions, quotes, sentiment tracking
- **Post-meeting automation** — Summary emails, follow-up sequences, reminders
- **Relationship memory** — Contact cards that persist across meetings
- **Meeting ROI scoring** — Weekly audits to eliminate time-wasters

## Install

```bash
clawhub install afrexai-meeting-mastery
```

## Quick Start

Tell your agent:
- **"Prep for my 2pm with Jane Smith"** → Full intelligence brief with agenda
- **"Take notes for standup"** → Structured capture template
- **"Follow up on yesterday's client call"** → Action item check + draft follow-ups
- **"Meeting audit"** → Weekly ROI analysis of all your meetings

## Why This vs Others

Most meeting skills just pull calendar events. This one:
- Researches every attendee before you walk in
- Generates different agendas for different meeting types (not one-size-fits-all)
- Tracks relationships across meetings so context compounds
- Scores meetings on ROI and tells you which ones to cut
- Builds follow-up sequences that actually close deals

Zero dependencies. Works with any calendar. Pure agent skill.

## ⚡ Level Up

Want industry-specific meeting frameworks (discovery calls, vendor evaluations, compliance reviews)?

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)** include meeting playbooks tailored to your vertical:
- **SaaS Pack** — Demo scripts, QBR templates, churn review frameworks
- **Professional Services Pack** — SOW review meetings, client kickoffs, project retros
- **Recruitment Pack** — Interview scorecards, panel coordination, offer call scripts

## 🔗 More Free Skills by AfrexAI

- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Find and qualify leads
- [afrexai-seo-content-engine](https://clawhub.com/skills/afrexai-seo-content-engine) — SEO content that ranks
- [afrexai-budget-tracker](https://clawhub.com/skills/afrexai-budget-tracker) — Smart budget management
- [afrexai-email-to-calendar](https://clawhub.com/skills/afrexai-email-to-calendar) — Extract events from emails
- [afrexai-lead-scorer](https://clawhub.com/skills/afrexai-lead-scorer) — Score and prioritize leads

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
