# Medical Billing & Revenue Cycle Management

AI agent skill for medical billing analysis, claim denial management, revenue cycle optimization, and healthcare compliance.

## Features

- **CPT/ICD-10 coding accuracy** — error detection, modifier guidance, E/M level validation
- **Denial analysis** — CARC/RARC code lookup, root cause mapping, appeal letter templates
- **Revenue cycle KPIs** — days in A/R, clean claim rate, denial rate, collection benchmarks
- **Payer contract analysis** — fee schedule comparison, underpayment detection, negotiation prep
- **Compliance** — OIG Work Plan, Stark Law, False Claims Act, audit readiness
- **Charge capture** — missed charges, lag analysis, superbill optimization
- **Patient responsibility** — eligibility verification, prior auth, No Surprises Act compliance

## Who This Is For

- Medical practices (any specialty)
- Revenue cycle management companies
- Healthcare billing departments
- Practice management consultants
- Healthcare IT teams building billing automation

## Quick Start

Install this skill in your AI agent (OpenClaw, Claude, etc.) and ask:

```
Our family medicine practice has 45 days in A/R and an 8% denial rate.
Payer mix: 40% Medicare, 30% commercial, 20% Medicaid, 10% self-pay.
What should we fix first?
```

## More Healthcare AI Tools

Get the complete Healthcare AI Context Pack — 50+ frameworks covering billing, compliance, clinical operations, and patient experience optimization.

**[Browse all context packs →](https://afrexai-cto.github.io/context-packs/)**

- Healthcare Pack — $47
- Pick any 3 packs — $97
- All 10 industry packs — $197

**[Free AI Revenue Calculator →](https://afrexai-cto.github.io/ai-revenue-calculator/)** — Find out how much revenue your practice is losing to manual processes.

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/)
