# AfrexAI MCP Engineering

Complete Model Context Protocol system — build, integrate, secure, and scale MCP servers for AI agents.

## Install

```bash
clawhub install afrexai-mcp-engineering
```

## What You Get

11-phase MCP engineering methodology:

1. **Fundamentals** — Architecture, concepts, transport selection
2. **Build** — TypeScript + Python server templates with tool design rules
3. **Production** — HTTP transport, auth patterns, production checklist
4. **Integration** — OpenClaw/Claude Desktop config, multi-server architecture
5. **Testing** — Test pyramid, per-tool checklist, MCP Inspector
6. **Patterns** — API wrapper, database, file system, workflow, aggregator
7. **Security** — Threat model, hardening checklist, dangerous patterns to avoid
8. **Debugging** — Common issues table, debug workflow, logging template
9. **Evaluation** — Score existing servers before using them (0-30 rubric)
10. **Architecture** — Single agent, gateway, agent-per-domain patterns + tool count limits
11. **Publishing** — Package structure, README template, npm publishing

Plus: 100-point quality rubric, 10 common mistakes, 12 natural language commands.

## Quick Start

Ask your agent:
- "Build an MCP server for [any API]"
- "Secure my MCP server for production"
- "Debug why my MCP tool isn't appearing"
- "How should I architect 5 MCP servers?"

## Why This Over Other MCP Skills

Other MCP skills are either CLI wrappers for specific tools or single-framework guides. This is the complete engineering methodology — from first tool to production multi-server architecture. Zero dependencies.

## ⚡ Level Up

Want production-ready AI agent configurations for your industry?

**AfrexAI Context Packs ($47)** — Complete agent setups for SaaS, Fintech, Healthcare, Legal, Construction, Ecommerce, Real Estate, Recruitment, Manufacturing, and Professional Services.

👉 [Browse Context Packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- `afrexai-agent-engineering` — Build autonomous AI agents
- `afrexai-api-architect` — Design production APIs
- `afrexai-system-architect` — System design methodology
- `afrexai-cybersecurity-engine` — Security engineering
- `afrexai-prompt-engineering` — Prompt design system

Find all AfrexAI skills: `clawhub search afrexai`
