# Margin Analysis & Profit Optimization

Analyze gross, operating, and net margins by product line, customer segment, and channel. Identify margin erosion patterns and build pricing power.

## When to Use
- Quarterly margin reviews
- Pricing decisions (new product, discount approval, bundle strategy)
- Cost structure changes (new vendor, headcount, infrastructure)
- Board prep or investor reporting
- Post-acquisition integration (blended margin modeling)

## Framework

### Step 1: Margin Stack (Top → Bottom)
Break revenue into layers. For each product/service line:

| Layer | Formula | Healthy Range |
|-------|---------|--------------|
| Gross Margin | (Revenue - COGS) / Revenue | 60-80% (SaaS), 30-50% (services), 20-40% (manufacturing) |
| Contribution Margin | (Revenue - Variable Costs) / Revenue | 40-70% |
| Operating Margin | EBIT / Revenue | 15-30% (mature), -20-10% (growth) |
| Net Margin | Net Income / Revenue | 10-25% (healthy), varies by stage |

### Step 2: Margin by Segment
Split margins across:
- **Product lines** — which products subsidize others?
- **Customer tiers** — enterprise vs mid-market vs SMB
- **Channels** — direct sales vs partner vs self-serve
- **Geography** — domestic vs international (FX, compliance costs)

### Step 3: Erosion Detection
Flag these patterns:
- Gross margin declining >2% QoQ without volume increase
- Discount frequency increasing (>30% of deals discounted)
- Customer acquisition cost (CAC) growing faster than LTV
- Support costs per customer rising (hidden COGS)
- Infrastructure costs scaling faster than revenue

### Step 4: Pricing Power Assessment
Score 1-5 on each:
1. **Switching costs** — how hard is it to leave?
2. **Differentiation** — can customers get this elsewhere?
3. **Value quantification** — can you prove $ ROI?
4. **Market position** — leader, challenger, or commodity?
5. **Contract structure** — annual, multi-year, usage-based?

Total 20+ = strong pricing power. Below 12 = commodity risk.

### Step 5: Optimization Levers

**Revenue side:**
- Price increase (1% price increase = 8-12% profit increase for most businesses)
- Upsell/cross-sell (expansion revenue at near-zero marginal cost)
- Usage-based pricing tiers (capture value from power users)
- Annual prepay discounts (improve cash flow, lock retention)

**Cost side:**
- Vendor renegotiation (benchmark against 3+ alternatives)
- Infrastructure right-sizing (cloud cost audits save 20-40%)
- Automation of manual processes (support, onboarding, billing)
- Headcount-to-revenue ratio optimization

### Step 6: Scenario Modeling
Build three scenarios for next 4 quarters:

| Scenario | Revenue Growth | Margin Change | Action |
|----------|---------------|---------------|--------|
| Base | Current trajectory | Flat | Maintain |
| Bull | +20% growth | +3-5% margin | Invest in scaling |
| Bear | -10% decline | -5-8% margin | Cut to protect cash |

For each: model cash runway, breakeven timeline, and hiring capacity.

## 2026 Benchmarks by Industry

| Industry | Gross Margin | Operating Margin | Net Margin |
|----------|-------------|-----------------|------------|
| SaaS (B2B) | 70-85% | 15-30% | 10-25% |
| Professional Services | 50-70% | 15-25% | 10-20% |
| Fintech | 60-75% | 10-25% | 8-20% |
| Healthcare Tech | 55-70% | 10-20% | 5-15% |
| Manufacturing | 25-45% | 8-15% | 5-12% |
| E-commerce | 30-50% | 5-15% | 3-10% |
| Construction Tech | 35-55% | 10-20% | 5-12% |
| Legal Tech | 65-80% | 20-35% | 15-25% |
| Real Estate Tech | 40-60% | 10-20% | 5-15% |
| Recruitment Tech | 55-70% | 12-22% | 8-18% |

## Red Flags
- Gross margin below industry median for 2+ quarters
- Negative contribution margin on any product (you're paying customers to use it)
- Operating margin declining while revenue grows (scaling inefficiency)
- Net margin negative with no clear path to breakeven
- Customer concentration >30% of revenue from top 3 accounts

## Output Template
```
MARGIN ANALYSIS — [Company/Division] — [Period]

Revenue: $X | Gross Margin: X% | Operating Margin: X% | Net Margin: X%
QoQ Trend: [improving/flat/declining]
vs Industry Benchmark: [above/at/below] by X%

TOP 3 FINDINGS:
1. [Finding + $ impact]
2. [Finding + $ impact]
3. [Finding + $ impact]

RECOMMENDATIONS:
1. [Action] → Expected margin impact: +X%
2. [Action] → Expected margin impact: +X%
3. [Action] → Expected margin impact: +X%

90-DAY PRIORITY: [Single highest-leverage action]
```

## Resources
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — find where margins are eroding
- [Industry Context Packs](https://afrexai-cto.github.io/context-packs/) ($47) — vertical-specific margin benchmarks and optimization playbooks
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — automate margin monitoring with AI agents
