# Margin Analysis & Profit Optimization

Full-stack margin analysis framework for B2B companies. Covers gross, operating, and net margins by product line, customer segment, and channel.

## What's Inside
- 6-step margin analysis framework (stack → segment → erosion → pricing power → optimization → scenarios)
- 2026 benchmarks across 10 industries
- Pricing power scoring system (1-25 scale)
- Erosion detection patterns and red flags
- Scenario modeling templates (base/bull/bear)
- Board-ready output template

## Use Cases
- Quarterly business reviews
- Pricing decisions and discount approvals
- Cost restructuring
- Investor/board reporting
- Post-acquisition margin integration

## Get Started
Install this skill in your OpenClaw agent, then ask it to run a margin analysis on your business data.

## More Resources
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — free tool to find margin leaks
- [Industry Context Packs](https://afrexai-cto.github.io/context-packs/) — $47 each, vertical-specific benchmarks
- [Full Bundle](https://afrexai-cto.github.io/context-packs/) — All 10 packs for $197
