# Logistics Operations Optimizer

Turn your AI agent into a logistics analyst. Paste your shipping data, warehouse metrics, or supply chain setup — get a complete optimization framework with benchmarks and savings estimates.

## What It Does

- **Route optimization** — hub-and-spoke vs direct vs milk run analysis with carrier rate comparison
- **Warehouse efficiency audit** — pick/pack/ship benchmarks, slotting optimization, labor productivity
- **Transportation spend analysis** — freight as % of revenue, accessorial charge audit, dim weight optimization
- **Inventory positioning** — safety stock formulas, reorder points, multi-echelon strategy
- **Carrier scorecards** — 5-metric weighted scoring across all your carriers
- **Returns management** — reverse logistics cost modeling, disposition rules, root cause analysis
- **KPI dashboard** — perfect order rate, cycle time, cost per order, inventory turns, fill rate

## Typical Results

| Optimization Area | Expected Savings |
|---|---|
| Route optimization | 10-15% freight reduction |
| Packaging right-sizing | 8-15% dim weight savings |
| Carrier negotiation | 5-12% rate reduction |
| Warehouse slotting | 15-25% pick time reduction |
| Returns optimization | 20-30% cost reduction |

## Who It's For

Operations managers, supply chain directors, logistics coordinators, ecommerce fulfillment teams, 3PL operators, warehouse managers.

## Example Prompt

> "We ship 500 orders/day from a single warehouse in Dallas. Average package is 5 lbs, dimensions 12x10x8. Using FedEx Ground for 80% of shipments. Returns are 22%. Give me the full optimization."

## Get More

- [AI Context Packs](https://afrexai-cto.github.io/context-packs/) — $47/pack, 10 industries covered (Manufacturing, Ecommerce, Construction, and more)
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — Find where your business is losing money to manual processes
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — Get your AI agent configured in 5 minutes

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
