# Legacy System Modernization Engine

Complete methodology for assessing, planning, and executing legacy system modernization — monolith decomposition, cloud migration, strangler fig patterns, database modernization, and more. Any tech stack, any scale.

## Install

```bash
clawhub install afrexai-legacy-modernization
```

## What You Get

- **Technical Debt Inventory** — 10-dimension scoring system with evidence tracking
- **Strategy Decision Matrix** — 8 strategies with selection decision tree
- **Strangler Fig Pattern** — step-by-step with facade YAML and sequencing rules
- **Monolith Decomposition** — domain discovery, bounded context mapping, extraction priority matrix
- **Database Modernization** — migration strategies, schema evolution rules, data quality gates
- **Cloud Migration** — readiness assessment, checklist, cost optimization from Day 1
- **API Modernization** — wrapping patterns, contract-first migration
- **Testing Strategy** — parity testing framework, performance regression rules
- **Language/Framework Playbooks** — Java, Python, jQuery→React, COBOL/mainframe
- **Risk Management** — top 10 pre-built risks, kill criteria
- **100-Point Quality Rubric** across 8 weighted dimensions

## Quick Start

Tell your agent: *"Assess this system for modernization"* — it'll run the full Technical Debt Inventory and recommend a strategy.

## Example

```
"We have a 15-year-old Java 8 monolith on-prem. 500K LOC, 12 developers. 
We need to get to cloud. What's the plan?"

→ Technical Debt Inventory → Strategy: Strangler Fig + Replatform
→ Domain discovery → Bounded contexts → Extraction sequence
→ Cloud readiness check → Migration phases → Testing plan
```

## ⚡ Level Up

For industry-specific modernization context (compliance requirements, integration patterns, vendor landscapes):

- **[SaaS Context Pack](https://afrexai-cto.github.io/context-packs/)** — $47
- **[Fintech Context Pack](https://afrexai-cto.github.io/context-packs/)** — $47
- **[Healthcare Context Pack](https://afrexai-cto.github.io/context-packs/)** — $47
- **[Manufacturing Context Pack](https://afrexai-cto.github.io/context-packs/)** — $47

## 🔗 More Free Skills by AfrexAI

- `afrexai-system-architect` — System architecture methodology
- `afrexai-devops-engine` — DevOps & platform engineering
- `afrexai-database-engineer` — Database engineering system
- `afrexai-api-architect` — API lifecycle management
- `afrexai-code-reviewer` — Code review framework

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
