# Commercial Lease Analyzer

Stop overpaying on commercial leases. This skill turns your AI agent into a lease analyst that catches hidden costs, flags unfavorable terms, and identifies negotiation leverage.

## What It Does

- **True cost calculation** — Base rent is never the real number. This models CAM, tax pass-throughs, insurance, load factor, parking, and escalations to show actual occupancy cost
- **Clause-by-clause risk scoring** — Flags demolition clauses, uncapped CAM, personal guarantees without sunsets, and 15+ other terms that cost tenants real money
- **Escalation modeling** — Year-by-year projections under fixed, CPI, and market reset scenarios
- **Multi-option comparison** — Side-by-side matrix when evaluating competing lease proposals
- **Negotiation playbook** — Ranked by dollar impact over the lease term, calibrated to current market vacancy

## Who Needs This

- **Business owners** signing or renewing office/retail/industrial leases
- **Real estate teams** evaluating multiple locations
- **CFOs** modeling lease liability under ASC 842
- **Property managers** benchmarking tenant costs
- **Startups** getting their first commercial space (where mistakes are expensive)

## Example Output

```
LEASE ANALYSIS: 450 Park Ave, Suite 800
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

VERDICT: NEGOTIATE

TRUE COST
Monthly: $18,750
Annual: $225,000
Full Term (5yr): $1,198,000
Per Employee: $781/mo (at 24 headcount)

RED FLAGS: 2
- Uncapped CAM escalation — projected $42,000 overpayment by Year 5
- Personal guarantee with no sunset — full liability for entire term

TOP 3 NEGOTIATION PRIORITIES:
1. CAM cap at 5% annual — savings: $42,000 over term
2. Personal guarantee sunset at Month 24 — risk reduction
3. Early termination at Year 3 — flexibility value: $225,000
```

## Covers All Lease Types

- Full-service gross (office)
- Modified gross
- Triple net (NNN) — retail and industrial
- Percentage rent (retail)
- Ground leases

Includes 2025-2026 benchmarks for 10 major US markets.

---

**Need deeper industry expertise?** Check out our [AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/) — real estate, construction, professional services, and 7 more verticals. $47 each.

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/).
