# AfrexAI Lead Hunter Pro

> Enterprise-grade B2B lead generation for AI agents. Discovery → Enrichment → Scoring → Outreach → CRM — fully autonomous.

## What This Does

Turns your AI agent into a complete sales development machine:

- **Multi-source discovery** — 8+ search strategies to find ideal prospects from web, GitHub, job boards, conferences, and more
- **Deep enrichment** — Company data, contact info, tech stack, pain signals, funding, email patterns
- **ICP scoring** — 100-point scoring rubric across 5 dimensions with automatic tier segmentation
- **Outreach sequences** — Battle-tested email templates for cold, warm, and LinkedIn campaigns
- **Pipeline management** — Full CRM schema with stage tracking, metrics, and weekly reporting
- **Autopilot mode** — Daily and weekly routines your agent runs without human intervention

## Install

```bash
clawhub install afrexai-lead-hunter
```

## Quick Start

1. Define your ICP (Ideal Customer Profile) using the template in SKILL.md
2. Set scoring weights for your market
3. Run discovery searches using the provided query templates
4. Enrich and score leads automatically
5. Deploy outreach sequences based on tier assignment

## What's Inside

- **ICP Builder** — YAML templates for company and persona profiles
- **8 Discovery Source Strategies** — with search query templates ready to use
- **Enrichment Checklists** — 14-point company + 8-point contact verification
- **Email Pattern Detection** — 7 common patterns with verification approach
- **100-Point Scoring Rubric** — Company (30) + Persona (20) + Intent (25) + Timing (15) + Engagement (10)
- **4 Outreach Templates** — Specific Pain, Value-First, LinkedIn Warm-Up, Breakup sequence
- **CRM Schema** — Complete JSON lead record format
- **Pipeline Stages** — 8-stage funnel from Prospect to Closed
- **Tracking Metrics** — 7 KPIs to optimize your pipeline
- **Daily Autopilot Routine** — Copy-paste into your agent's cron

## Why This Over Other Lead Gen Skills?

| Feature | Others | AfrexAI Lead Hunter |
|---------|--------|-------------------|
| ICP Definition | Basic | Full YAML templates with anti-signals |
| Discovery Sources | 2-3 | 8+ with search query templates |
| Enrichment | Surface-level | 22-point checklist |
| Scoring | Simple yes/no | 100-point rubric, 5 dimensions |
| Outreach Templates | None | 4 battle-tested sequences |
| Pipeline Management | None | Full CRM schema + metrics |
| Automation Guide | None | Daily + weekly routines |

## ⚡ Level Up

Want industry-specific context packs that supercharge your lead hunter with vertical-specific ICP data, pain points, and outreach angles?

**[$47 Context Packs](https://afrexai-cto.github.io/context-packs/)** — Available for:
- SaaS & Software Companies
- Professional Services & Consulting
- Fintech & Financial Services
- Legal & Compliance
- Healthcare & Life Sciences
- Construction & Real Estate
- Manufacturing & Supply Chain
- E-commerce & Retail
- Recruitment & HR Tech

Each pack includes pre-built ICPs, industry pain maps, competitor landscapes, and customized outreach templates for that vertical.

## 🔗 More Free Skills by AfrexAI

- `afrexai-email-to-calendar` — Extract meetings, deadlines, and events from emails
- `afrexai-humanizer` — Make AI-generated content sound human
- `afrexai-prospect-researcher` — Deep-dive research on specific companies
- `afrexai-email-triager` — Intelligent inbox sorting and prioritization
- `afrexai-meeting-prep` — Auto-generate briefs before any meeting

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛 — AI agents that actually sell.*
