# 🧠 Knowledge Management System by AfrexAI

**Stop losing expertise when people leave.** Turn tribal knowledge into searchable, maintained organizational intelligence.

## What This Does

Your AI agent becomes a knowledge management consultant that:
- Audits your current knowledge state and identifies single-points-of-failure
- Designs taxonomy, templates, and contribution workflows
- Creates runbooks, ADRs, troubleshooting guides, and decision trees from templates
- Tracks document freshness and assigns review schedules
- Measures KB health with a 100-point scoring system

## Install

```bash
clawhub install afrexai-knowledge-management
```

## Quick Start

```
"Audit our knowledge management"
"Design a KB structure for our engineering team"
"Write a runbook for deploying to production"
"Plan knowledge extraction for our departing engineer"
```

## What's Inside

- **Knowledge Risk Register** — identify single-points-of-failure before they leave
- **5 Document Templates** — runbook, reference, ADR, troubleshooting, decision tree
- **4C Quality Test** — Clear, Correct, Current, Concise
- **Contribution System** — incentives, workflows, cultural norms
- **Freshness Policy** — automated review schedules with escalation
- **Health Dashboard** — 6-dimension scoring (0-100) with KPIs
- **Knowledge Capture Workflows** — post-incident, post-meeting, new hire, exit transfer
- **Cross-Team Knowledge Map** — who produces/consumes what
- **ROI Calculator** — prove the value of documentation

## ⚡ Level Up

This free skill gives you the methodology. For industry-specific knowledge frameworks with pre-built templates, compliance mappings, and domain taxonomies:

**[AfrexAI Context Packs — $47](https://afrexai-cto.github.io/context-packs/)**

- 🏥 Healthcare Pack — HIPAA documentation requirements, clinical knowledge management
- 💻 SaaS Pack — Engineering knowledge systems, API documentation architecture
- 🏗️ Construction Pack — Safety procedures, project knowledge transfer
- ⚖️ Legal Pack — Case knowledge management, precedent libraries

## 🔗 More Free Skills by AfrexAI

- [afrexai-technical-docs](https://clawhub.com/skills/afrexai-technical-docs) — Technical documentation engine
- [afrexai-employee-onboarding](https://clawhub.com/skills/afrexai-employee-onboarding) — 30/60/90 day onboarding system
- [afrexai-engineering-manager](https://clawhub.com/skills/afrexai-engineering-manager) — Complete EM operating system
- [afrexai-compliance-engine](https://clawhub.com/skills/afrexai-compliance-engine) — Multi-framework compliance
- [afrexai-risk-management](https://clawhub.com/skills/afrexai-risk-management) — Enterprise risk management

**Browse all AfrexAI skills:** [clawhub.com](https://clawhub.com)  
**Full storefront:** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
