# Invoice Engine — Complete Invoicing & AR for AI Agents

Professional invoicing, payment tracking, overdue management, and financial reporting — all in one agent skill. Zero dependencies.

## Install

```bash
clawhub install afrexai-invoice-engine
```

## What It Does

- **Create invoices** from natural language ("invoice Acme for 20 hours at $250")
- **Client registry** with payment terms, tax handling, and history
- **Recurring billing** — auto-generate monthly/quarterly invoices
- **Overdue automation** — reminder schedule with email templates at +1, +7, +14, +30 days
- **Revenue dashboard** — collection rate, DSO, aging report, monthly trends
- **Quote-to-invoice pipeline** — proformas → accepted → invoice → paid
- **Multi-currency** — USD, GBP, EUR, BTC/Lightning
- **Credit notes & adjustments** — partial refunds, corrections, write-offs
- **Tax handling** — decision tree for domestic, cross-border, EU reverse charge, tax-exempt
- **Late fee calculation** — configurable rates with grace periods

## Quick Start

Just tell your agent:
- "Invoice [client] for [description]"
- "What's overdue?"
- "Revenue this month"
- "Set up recurring: [client] $3,500/month"

The skill handles numbering, tax logic, payment terms, and tracking automatically.

## Why This Over Others?

| Feature | Others | This Skill |
|---|---|---|
| Dependencies | Node.js + weasyprint | Zero |
| Client management | ❌ | Full registry + onboarding |
| Recurring billing | ❌ | Auto-generate on schedule |
| Overdue automation | ❌ | 5-stage reminder sequence |
| Revenue reporting | ❌ | Dashboard + aging + trends |
| Multi-currency | ❌ | USD/GBP/EUR/BTC |
| Quote pipeline | ❌ | Quote → Accept → Invoice |
| Tax handling | Basic | Decision tree by region |
| Credit notes | ❌ | Full adjustment workflow |
| Late fees | ❌ | Auto-calculate with caps |

## ⚡ Level Up

Get the full **AI Context Pack** for your industry — includes invoicing context PLUS market landscape, competitor analysis, compliance frameworks, and automation playbooks:

- [SaaS Context Pack ($47)](https://afrexai-cto.github.io/context-packs/) — subscription billing, MRR tracking, churn revenue
- [Professional Services Pack ($47)](https://afrexai-cto.github.io/context-packs/) — time & materials, retainers, milestone billing
- [Manufacturing Pack ($47)](https://afrexai-cto.github.io/context-packs/) — purchase orders, materials billing, progress invoicing

**🔗 More free skills by AfrexAI:**
- [afrexai-lead-hunter](https://clawhub.com/skills/afrexai-lead-hunter) — Find and qualify leads
- [afrexai-budget-tracker](https://clawhub.com/skills/afrexai-budget-tracker) — Track spending and budgets
- [afrexai-business-automation](https://clawhub.com/skills/afrexai-business-automation) — Automate workflows
- [afrexai-proposal-engine](https://clawhub.com/skills/afrexai-proposal-engine) — Win deals with killer proposals
- [afrexai-customer-support](https://clawhub.com/skills/afrexai-customer-support) — Support at scale

**Browse all AfrexAI skills →** [afrexai-cto.github.io/context-packs](https://afrexai-cto.github.io/context-packs/)
