# Investor Update Generator

Generate professional monthly/quarterly investor updates that keep stakeholders informed and build trust.

## What This Does

Takes your company metrics and turns them into a structured investor update — the kind that gets forwarded to other investors and opens doors for your next round.

## How to Use

Tell your agent: "Write my investor update for [month/quarter]"

Provide:
- Revenue / MRR / ARR numbers
- Key wins and milestones
- Challenges and how you're addressing them
- Cash position and runway
- Key hires or team changes
- Asks (intros, advice, resources)

## Update Structure

### 1. TL;DR (3 bullets max)
The headline numbers. If an investor reads nothing else, they get the picture.

### 2. Key Metrics Dashboard

| Metric | This Period | Last Period | Change |
|--------|-----------|------------|--------|
| MRR/ARR | | | |
| Revenue | | | |
| Customers | | | |
| Burn Rate | | | |
| Runway (months) | | | |
| NRR | | | |
| CAC Payback | | | |

### 3. Wins
What went right. Be specific — names, numbers, dates. "Closed Acme Corp ($120K ACV)" beats "signed new enterprise client."

### 4. Challenges
What's hard right now. Investors respect honesty. Frame as: problem → what you're doing about it → expected timeline.

### 5. Product & Engineering
Ship log. What launched, what's in progress, what's next. Link to demos if possible.

### 6. Team
New hires, departures, org changes. Headcount trajectory.

### 7. Cash & Runway
- Starting cash
- Revenue collected
- Burn
- Ending cash
- Runway at current burn

### 8. The Ask
Be specific. "Intro to [person] at [company] for [reason]" converts. "Any intros would be great" doesn't.

## Frequency Guide

| Stage | Frequency | Length |
|-------|-----------|--------|
| Pre-Seed/Seed | Monthly | 1 page |
| Series A | Monthly | 1-2 pages |
| Series B+ | Quarterly | 2-3 pages |

## Writing Rules

1. **Lead with metrics** — numbers first, narrative second
2. **Be honest about bad news** — burying it destroys trust faster than the bad news itself
3. **Consistent format** — same structure every time so investors can scan quickly
4. **Send on time** — first week of month/quarter, no exceptions
5. **Include a forward look** — what you expect next period
6. **Keep it under 2 pages** — respect their time
7. **End with a specific ask** — every update is an opportunity

## Red Flags to Avoid

- Skipping months when things are bad
- Vanity metrics without context (MAU without retention)
- Vague language ("things are going well")
- No mention of cash position
- Asking for nothing (missed opportunity)

## Templates by Stage

### Pre-Seed Monthly (5 min read)
```
Subject: [Company] — [Month] Update: [One-line headline]

Hi [First Name],

TL;DR:
• [Metric 1 headline]
• [Metric 2 headline]  
• [Key win or milestone]

[2-3 paragraphs covering metrics, progress, challenges]

The Ask: [Specific request]

Thanks for your support,
[Name]
```

### Series A Quarterly (10 min read)
```
Subject: [Company] Q[X] 2026 Update — [Headline metric]

Executive Summary: [3 bullets]

Financial Highlights: [Table]

Product: [Ship log]

Go-to-Market: [Pipeline, wins, losses]

Team: [Changes, hiring plan]

Outlook: [Next quarter targets]

Board Items: [Decisions needed]

Asks: [Specific requests with context]
```

## Benchmarks (2026)

| Metric | Bottom Quartile | Median | Top Quartile |
|--------|----------------|--------|--------------|
| MoM Growth (Seed) | <5% | 10-15% | >20% |
| Net Revenue Retention | <90% | 100-110% | >130% |
| Burn Multiple | >3x | 1.5-2x | <1x |
| CAC Payback | >18mo | 12mo | <6mo |
| Logo Churn | >5%/mo | 2-3%/mo | <1%/mo |

---

*Need the full context for your industry? Check out [AfrexAI Context Packs](https://afrexai-cto.github.io/context-packs/) — $47 each, covering Fintech, Healthcare, Legal, SaaS, and 6 more verticals. Or grab the [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) to see what you're leaving on the table.*
