# Investor Relations Framework

Complete IR playbook for startups and growth companies managing investor communications, reporting, and capital market positioning.

## What This Covers

### Quarterly Investor Update Template
- Financial summary (revenue, burn, runway, key metrics)
- Product milestones and roadmap progress
- Team changes and hiring pipeline
- Risks and asks (be direct — investors respect honesty)
- Forward-looking guidance with confidence ranges

### Annual Shareholder Letter
- Year-in-review narrative (numbers + story)
- Strategic priorities for next 12 months
- Capital allocation decisions and rationale
- Market positioning and competitive landscape

### Investor Meeting Prep
- Pre-meeting checklist (data room, metrics, deck updates)
- Anticipated questions by investor type (VC, PE, angel, strategic)
- Follow-up cadence (24hr thank you → 1 week materials → monthly updates)

### Cap Table Management
- Round modeling (dilution scenarios at different valuations)
- Option pool sizing (10-20% standard, adjust by stage)
- Pro-rata rights tracking
- Waterfall analysis for exit scenarios

### IR Calendar
| Month | Activity |
|-------|----------|
| Jan | Annual letter + board deck |
| Mar | Q1 update + fundraise prep (if needed) |
| Jun | Q2 update + mid-year strategy review |
| Sep | Q3 update + annual planning preview |
| Dec | Year-end close prep + investor holiday note |

### KPI Dashboard for Investors
Track and report these monthly:
- **Revenue**: MRR/ARR, growth rate, net revenue retention
- **Unit economics**: CAC, LTV, LTV:CAC ratio, payback months
- **Efficiency**: Burn multiple, Rule of 40, magic number
- **Product**: DAU/MAU, activation rate, NPS
- **Team**: Headcount, attrition, open roles

### Investor Communication Rules
1. Bad news travels fast — YOU should be the source, not rumor
2. Under-promise, over-deliver (set guidance at 80% confidence)
3. Monthly updates even when there's "nothing to report" — silence kills trust
4. Format: bullet points, not essays. Investors read 50+ updates/month
5. Always include an ask — intros, advice, customers, talent

### Crisis Communication
- Revenue miss: acknowledge, explain root cause, share recovery plan
- Key person departure: announce proactively with transition plan
- Pivot: frame as learning, not failure. Show new thesis with data
- Cash crunch: be transparent about runway and options

### Fundraise Readiness Score (0-100)
| Factor | Weight | Score Range |
|--------|--------|-------------|
| Revenue growth | 25% | 0-100 |
| Unit economics | 20% | 0-100 |
| Team completeness | 15% | 0-100 |
| Market size evidence | 15% | 0-100 |
| Product-market fit signals | 15% | 0-100 |
| Data room readiness | 10% | 0-100 |

**70+ = Ready to fundraise**
**50-69 = 2-3 months of work needed**
**Below 50 = Not ready — focus on business fundamentals**

## Industry Applications

| Industry | Key IR Metrics | Investor Focus |
|----------|---------------|----------------|
| SaaS | ARR, NRR, CAC payback | Capital efficiency |
| Fintech | TPV, take rate, regulatory status | Compliance + scale |
| Healthcare | Lives covered, clinical outcomes | Regulatory pathway |
| Ecommerce | GMV, AOV, repeat rate | Customer acquisition |
| Construction | Backlog, project margin, win rate | Revenue visibility |
| Manufacturing | Utilization, yield, order book | Operational leverage |
| Real Estate | AUM, occupancy, NOI | Asset quality |
| Legal | Matter volume, realization rate | Efficiency gains |
| Recruitment | Placements, fill rate, revenue/head | Market position |
| Professional Services | Utilization, bill rate, retention | Margin expansion |

## Tools

Get the full context pack for your industry — pre-built agent configs, prompts, and workflows:
- **Browse all 10 packs**: https://afrexai-cto.github.io/context-packs/
- **Calculate your AI ROI**: https://afrexai-cto.github.io/ai-revenue-calculator/
- **Set up your AI agent**: https://afrexai-cto.github.io/agent-setup/

### Bundle Deals
- Pick 3 packs — $97 (save $44)
- All 10 packs — $197 (save $273)
- Everything Bundle — $247 (all packs + setup wizard + priority support)
