# Investment Analysis & Portfolio Management Engine 📈

Complete investment analysis, portfolio construction, risk management, and trade execution methodology for AI agents. Works across stocks, crypto, ETFs, bonds, and alternatives.

## Install

```bash
clawhub install afrexai-investment-engine
```

## What You Get

- **Thesis-First Investing** — Every position starts with a documented edge, invalidation criteria, and expected value calculation
- **12-Phase System** — From idea generation through thesis → analysis → sizing → execution → tracking → tax optimization
- **Multi-Asset Coverage** — Equities, crypto (on-chain metrics, tokenomics), ETFs, bonds, dividends, options hedging
- **Risk Management Framework** — Position sizing calculator, Kelly criterion, portfolio heat tracking, correlation matrix, stop-loss decision tree
- **Performance Analytics** — Trade journal, daily dashboard, monthly review, 9 key metrics (Sharpe, Sortino, profit factor, etc.)
- **Market Regime Detection** — Bull/bear/range/panic identification with strategy adjustments per regime
- **Investor Psychology** — 10 cognitive bias defenses with daily checklist
- **Tax Optimization** — Loss harvesting rules, holding period strategy, account allocation guide
- **100-Point Quality Rubric** — Score your investment process across 7 dimensions
- **Zero Dependencies** — Pure methodology, no APIs or scripts required

## Quick Start

```
You: "Analyze BTC"
Agent: [Runs full fundamental + technical + on-chain analysis with thesis template]

You: "Size position for AAPL at $190 with stop at $175"
Agent: [Calculates position size based on 2% risk rule, checks portfolio heat]

You: "Portfolio health check"
Agent: [Scores current state /8, flags issues]
```

## ⚡ Level Up

Want industry-specific investment analysis frameworks?

- [**Fintech Context Pack**](https://afrexai-cto.github.io/context-packs/) — $47 — Deep financial services analysis
- [**SaaS Context Pack**](https://afrexai-cto.github.io/context-packs/) — $47 — SaaS metrics & unit economics

## 🔗 More Free Skills by AfrexAI

- `afrexai-data-analyst` — Data analysis & visualization methodology
- `afrexai-fpa-engine` — Financial planning & analysis
- `afrexai-founder-os` — Startup operating system
- `afrexai-budget-tracker` — Personal & business budgeting
- `afrexai-pricing-strategy` — Pricing optimization

**[Browse all AfrexAI skills →](https://afrexai-cto.github.io/context-packs/)**
