# 📦 Inventory & Supply Chain Manager

Complete inventory management, demand forecasting, supplier evaluation, and supply chain optimization — built for real businesses, not home closet organizing.

## Install

```bash
clawhub install afrexai-inventory-supply-chain
```

## What You Get

- **ABC-XYZ Classification** — Automatically categorize every SKU by value and demand variability
- **Demand Forecasting** — Moving average, exponential smoothing, and seasonal decomposition methods
- **Reorder Point Calculator** — Safety stock formulas with service level targeting
- **EOQ Optimization** — Economic Order Quantity with MOQ and price break adjustments
- **Supplier Scorecards** — 100-point quarterly evaluation across quality, delivery, cost, responsiveness, flexibility
- **Warehouse Management** — Zone strategy, location coding, cycle counting schedules
- **Purchase Order Workflow** — From auto-trigger to receiving and QC
- **Stockout Prevention** — Early warning system with days-of-stock monitoring
- **Dead Stock Liquidation** — Progressive markdown and channel-shift strategies
- **Metrics Dashboard** — Turns, fill rate, GMROI, shrinkage, carrying costs

## Quick Start

Tell your agent:
- *"Classify my inventory using ABC-XYZ"*
- *"Calculate reorder point for SKU-001"*
- *"Score our top 3 suppliers"*
- *"Show stockout risks for next 30 days"*
- *"Generate a purchase order for [supplier]"*

## Who It's For

Any business that buys, stocks, and sells physical products — ecommerce, manufacturing, wholesale, retail, food service, construction.

---

## ⚡ Level Up

This free skill gives you the operational framework. For industry-specific inventory strategies with vendor landscapes, compliance requirements, and market context:

- 🏭 [**Manufacturing Context Pack**](https://afrexai-cto.github.io/context-packs/) — Production scheduling, MRP, lean manufacturing inventory
- 🛒 [**Ecommerce Context Pack**](https://afrexai-cto.github.io/context-packs/) — FBA inventory, marketplace stock sync, seasonal planning
- 🏗️ [**Construction Context Pack**](https://afrexai-cto.github.io/context-packs/) — Material procurement, site logistics, waste tracking

**$47 each** — instant download, plug into any AI agent.

## 🔗 More Free Skills by AfrexAI

- [`afrexai-budget-tracker`](https://clawhub.com/skills/afrexai-budget-tracker) — Financial tracking & health scoring
- [`afrexai-business-automation`](https://clawhub.com/skills/afrexai-business-automation) — Workflow automation frameworks
- [`afrexai-lead-hunter`](https://clawhub.com/skills/afrexai-lead-hunter) — ICP-driven prospecting engine
- [`afrexai-data-analyst`](https://clawhub.com/skills/afrexai-data-analyst) — Analysis frameworks & dashboards
- [`afrexai-invoice-engine`](https://clawhub.com/skills/afrexai-invoice-engine) — Invoicing & accounts receivable

👉 [**Browse all AfrexAI skills & packs**](https://afrexai-cto.github.io/context-packs/)
