# Interview Architect

> Evidence-based hiring interview system — scorecards, structured questions, evaluation rubrics, and bias mitigation. Stop hiring on gut feel.

## Install

```bash
clawhub install afrexai-interview-architect
```

## What You Get

An 8-phase system that turns "read resume, ask some questions" into a predictive hiring machine:

1. **Job Scorecard** — Define A-Player standards before seeing a single resume
2. **Interview Structure** — Stage-by-stage loop design with pass rates and timing
3. **Question Banks** — Behavioral (STAR), forensic resume probes, future simulations
4. **Technical Assessments** — Live coding, take-home, and system design rubrics
5. **Evaluation & Decision** — Independent scoring, structured debrief protocol, decision matrix
6. **Bias Mitigation** — 10 common biases with specific countermeasures
7. **Candidate Experience** — Communication templates for every stage
8. **Process Audit** — Quarterly review metrics, question effectiveness tracking, interviewer calibration

## Quick Start

```
"Design interviews for Senior Backend Engineer"
"Create a scorecard for Product Manager"
"Generate behavioral questions for ownership"
"Build a take-home for frontend role"
"Audit our interview process"
```

## Why This Over Alternatives

The `interview-designer` skill covers one methodology (Topgrading) in 3.8KB. Good framework, thin execution. This is 30KB covering the full hiring lifecycle — from scorecard design through offer, with complete question banks, scoring rubrics for every interview type, bias mitigation checklists, and quarterly process improvement. Every template is fill-in-ready.

## ⚡ Level Up

Need complete recruiting workflows beyond just interviews?

- **Recruitment Context Pack** ($47) — Full hiring pipeline: sourcing, screening, interviewing, onboarding
- **SaaS Context Pack** ($47) — Technical hiring + team building for SaaS companies
- **Professional Services Context Pack** ($47) — Consultant and specialist hiring

👉 [Browse all context packs](https://afrexai-cto.github.io/context-packs/)

## 🔗 More Free Skills by AfrexAI

- [afrexai-recruiting-engine](https://clawhub.com/skills/afrexai-recruiting-engine) — Full recruiting pipeline
- [afrexai-employee-onboarding](https://clawhub.com/skills/afrexai-employee-onboarding) — New hire → productive contributor
- [afrexai-negotiation-mastery](https://clawhub.com/skills/afrexai-negotiation-mastery) — Offer negotiation frameworks
- [afrexai-meeting-mastery](https://clawhub.com/skills/afrexai-meeting-mastery) — Interview prep + follow-up
- [afrexai-stakeholder-management](https://clawhub.com/skills/afrexai-stakeholder-management) — Hiring committee alignment

---

Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛
