# Insurance Claims Processor

Turn raw claim data into structured analysis with liability scoring, reserve estimates, fraud detection, and settlement strategy.

Covers property, liability, workers' comp, auto, and professional indemnity claims across US and UK jurisdictions.

## Install

```
clawhub install afrexai-insurance-claims
```

## What You Get

- **Coverage mapping** — matches incidents to policy provisions, endorsements, exclusions
- **Liability scoring** — 1-10 scale with comparative negligence analysis
- **Reserve estimates** — three-point (low/mid/high) with ALAE/ULAE breakdown
- **Fraud detection** — pattern-based red flag scoring
- **Subrogation analysis** — recovery potential and cost-benefit
- **Settlement strategy** — opening position, authority range, mediation vs litigation
- **Compliance timeline** — jurisdiction-specific deadlines and bad faith triggers

## Who This Is For

- Claims adjusters processing high volume
- Insurance operations managers automating triage
- Risk managers handling self-insured retentions
- TPAs standardizing claim handling procedures
- InsurTech teams building claims automation

## More From AfrexAI

- [AI Agent Context Packs](https://afrexai-cto.github.io/context-packs/) — $47 industry packs covering 10 verticals
- [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) — see what AI agents save your operation
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/) — configure your AI workforce in 5 minutes
