# Insurance Operations Automation

AI agent skill for insurance brokers, MGAs, and carriers. Covers underwriting, claims, policy admin, broker operations, and compliance.

Built on the 5-agent pipeline architecture (inspired by Jointly AI's autonomous broker model): Intake → Research → Execution → Analysis → Delivery.

## Install
```
clawhub install afrexai-insurance-automation
```

## What's Inside
- Underwriting risk scoring (12 factors, weighted by line)
- Claims triage pipeline (Green/Yellow/Red + fraud detection)
- Quote comparison automation (4 parallel carrier interactions)
- Compliance frameworks (FCA, state DOI, NAIC, Solvency II, IDD)
- Insurance metrics dashboard with targets
- 90-day deployment roadmap
- Cost framework by organization size

## Who This Is For
- Insurance brokers automating quote-to-bind
- MGAs building underwriting automation
- Carriers modernizing claims processing
- Insurtechs building agent-first platforms

## Resources
- [AI Revenue Leak Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/)
- [Industry Context Packs](https://afrexai-cto.github.io/context-packs/) ($47/pack)
- [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)

*AfrexAI — turning AI agent intelligence into revenue.*
