# HVAC Business Operations

Complete operations reference for HVAC contractors and service companies. Covers residential and commercial pricing, technician productivity, seasonal planning, equipment margins, EPA compliance, and growth strategy.

## What This Covers

### Pricing & Revenue
- **Service calls**: $89-150 diagnostic fee, $150-500 standard repair
- **Installation**: Residential systems $5,000-15,000 (equipment + labor), commercial $15,000-100,000+
- **Maintenance agreements**: $150-300/year residential, $500-2,000/year commercial
- **Emergency/after-hours**: 1.5x-2x standard rates
- **Target gross margins**: 50-55% service, 35-45% installation, 60%+ maintenance agreements

### Labor & Technician Management
- **Technician pay**: $22-35/hr (journeyman), $35-50/hr (senior/master), $18-22/hr (apprentice)
- **Billable rate**: $95-175/hr residential, $125-225/hr commercial
- **Revenue per tech**: Target $180,000-250,000/year
- **Utilization target**: 75-85% billable hours
- **Truck rolls per day**: 4-6 service calls, 1-2 installs
- **Spiff programs**: $50-200 per maintenance agreement sold by tech, $100-500 per equipment upsell

### Seasonal Planning
- **Peak seasons**: Summer (cooling) Jun-Aug, Winter (heating) Nov-Feb
- **Shoulder seasons**: Spring tune-ups Mar-May, Fall tune-ups Sep-Nov
- **Revenue split**: 40% cooling, 35% heating, 25% maintenance/other
- **Staffing**: Scale 20-30% temp labor for peak, cross-train for shoulder work
- **Cash reserves**: 3 months operating expenses minimum for off-peak

### Equipment & Inventory
- **Top brands (residential)**: Carrier, Trane, Lennox, Rheem, Goodman, Daikin
- **Markup**: 40-60% on equipment, 100-200% on parts
- **Inventory turns**: Target 8-12x/year on common parts
- **Must-stock parts**: capacitors, contactors, fan motors, thermostats, refrigerant, filters
- **Vehicle inventory**: $3,000-5,000 per truck in common parts

### Compliance & Licensing
- **EPA Section 608**: Universal certification required for all techs handling refrigerant
- **EPA 2025 AIM Act**: HFC phasedown — R-410A production cuts, R-454B transition underway
- **State contractor license**: Required in most states, continuing education 8-24 hrs/year
- **NATE certification**: Industry standard, higher close rates for certified techs
- **OSHA**: Confined space, electrical safety, refrigerant handling, fall protection for rooftop units
- **Building permits**: Required for new installations and major replacements in most jurisdictions

### KPIs & Metrics
| Metric | Target |
|--------|--------|
| Revenue per technician | $180K-250K/year |
| Service agreement retention | 80%+ |
| First-call fix rate | 85%+ |
| Average ticket | $350-500 (service), $8,000-12,000 (install) |
| Maintenance agreement attachment | 40%+ of service calls |
| Customer acquisition cost | $150-300 |
| Google review rating | 4.5+ stars |
| Callback rate | <5% |

### Marketing & Lead Generation
- **Google Local Services Ads**: $25-75 per lead, highest intent
- **Google Ads**: $15-40 per click for HVAC keywords
- **Cost per lead target**: $50-150
- **Conversion rate**: 60-70% for inbound service calls
- **Review generation**: Ask after every completed job, target 5+ new reviews/week
- **Referral program**: $50-100 credit per referred customer
- **Maintenance agreement database**: Your most valuable asset — recurring revenue + replacement pipeline

### Growth Playbook
1. **$0-500K**: Owner-operator + 1-2 techs, residential service focus, build review base
2. **$500K-1.5M**: 3-5 techs, add installations, hire dispatcher, maintenance agreement push
3. **$1.5M-3M**: Dedicated install crews, commercial entry, service manager, fleet 5-8 trucks
4. **$3M-5M**: Commercial contracts, energy efficiency audits, building automation, 10-15 techs
5. **$5M+**: Multiple locations or territories, new construction partnerships, property management contracts

### Technology Stack
- **Field service management**: ServiceTitan ($250-500/mo), Housecall Pro ($65-200/mo), Jobber ($70-200/mo)
- **Dispatch**: GPS fleet tracking ($25-40/truck/mo), route optimization
- **Flat rate pricing book**: Required — eliminates technician pricing inconsistency
- **Customer communication**: Automated appointment reminders, on-my-way texts, review requests
- **Proposal software**: Digital quotes with good-better-best options increase average ticket 25-35%

## Usage

Ask your agent about HVAC business operations, pricing, compliance, seasonal planning, or growth strategy. Works with any AI agent platform.

For complete industry context packs with deeper operational playbooks, visit the [AfrexAI Context Pack Store](https://afrexai-cto.github.io/context-packs/).
