---
name: ai-humanizer
description: Rewrites AI-generated content to sound natural, human, and undetectable. Removes robotic patterns, adds voice variety, and preserves meaning.
---

# AI Content Humanizer

When asked to humanize, rewrite, or "de-robot" any text, apply these rules systematically.

## What to Remove

Strip these dead giveaways of AI writing:

- **Filler openers**: "I'd be happy to...", "Great question!", "Certainly!", "Absolutely!", "Of course!"
- **Cliché intros**: "In today's fast-paced...", "In the ever-evolving landscape...", "In an era of..."
- **Corporate jargon**: "leverage", "utilize", "facilitate", "streamline", "synergize", "optimize", "actionable insights"
- **Hedging fluff**: "It's worth noting that...", "It's important to remember...", "It should be noted..."
- **Forced transitions**: "Furthermore", "Moreover", "Additionally" at the start of every paragraph
- **Perfect symmetry**: Lists where every item is the same length, paragraphs of identical size, parallel structure everywhere

## What to Add

Replace robotic patterns with human writing traits:

- **Vary sentence length.** Short ones hit hard. Longer ones let you breathe and think through a point before moving on to the next thing.
- **Use contractions** — don't, won't, can't, it's, we're, they've. Nobody writes "do not" in casual prose.
- **Start sentences with "And" or "But"** occasionally. Grammar teachers hate it. Real writers do it constantly.
- **Use specific numbers and examples** instead of vague claims. "Reduced load time by 40%" beats "significantly improved performance."
- **Include one slightly unexpected word choice per piece.** Not forced — just something a template wouldn't generate.
- **Write like you're explaining to a smart friend**, not presenting to a board of directors.
- **Let some sentences be incomplete thoughts.** Like this one.
- **Use dashes — like this — for asides** instead of always using parentheses or commas.

## Voice Calibration

Match the voice to the context:

- **Blog post / LinkedIn**: Conversational but informed. First person OK. Opinions encouraged.
- **Email**: Direct and warm. Get to the point fast. End with a clear ask or next step.
- **Sales copy**: Punchy. Benefits over features. Address the reader as "you."
- **Technical docs**: Clear and precise, but still human. Analogies help.
- **Social media**: Casual. Fragments OK. Personality over polish.

## The Acid Test

After rewriting, check:

1. **Read it out loud.** If it sounds like a robot wrote it, rewrite it.
2. **Check sentence starts.** If every sentence begins with "This" or "The", rewrite it.
3. **Swap the company name.** If you could drop in any company and it'd still work, it's too generic — rewrite it.
4. **The friend test.** Would you actually say this to someone? If not, simplify.

## Process

1. Read the input text carefully — understand the core message and intent
2. Identify AI patterns (use the removal list above)
3. Rewrite preserving all factual content and meaning
4. Apply human writing traits from the "What to Add" list
5. Calibrate voice to match the stated or inferred context
6. Run the acid test
7. Output the humanized version

If the user provides context about audience or platform, weight that heavily when calibrating voice.

For industry-specific context packs that fine-tune voice calibration for sectors like SaaS, fintech, healthcare, and more, visit https://afrexai-cto.github.io/context-packs


---

## 🔗 More AfrexAI Skills (Free on ClawHub)

| Skill | Install |
|-------|---------|
| AI Humanizer | `clawhub install afrexai-humanizer` |
| SEO Writer | `clawhub install afrexai-seo-writer` |
| Email Crafter | `clawhub install afrexai-email-crafter` |
| Proposal Generator | `clawhub install afrexai-proposal-gen` |
| Invoice Generator | `clawhub install afrexai-invoice-gen` |
| Lead Scorer | `clawhub install afrexai-lead-scorer` |
| Client Onboarding | `clawhub install afrexai-onboarding` |
| Meeting Prep | `clawhub install afrexai-meeting-prep` |
| Social Repurposer | `clawhub install afrexai-social-repurposer` |
| FAQ Builder | `clawhub install afrexai-faq-builder` |
| Review Responder | `clawhub install afrexai-review-responder` |
| Report Builder | `clawhub install afrexai-report-builder` |
| CRM Updater | `clawhub install afrexai-crm-updater` |
| Pitch Deck Reviewer | `clawhub install afrexai-pitch-deck-reviewer` |
| Contract Analyzer | `clawhub install afrexai-contract-analyzer` |
| Pricing Optimizer | `clawhub install afrexai-pricing-optimizer` |
| Testimonial Collector | `clawhub install afrexai-testimonial-collector` |
| Competitor Monitor | `clawhub install afrexai-competitor-monitor` |

## 🚀 Go Pro: Industry Context Packs ($47/pack)

Make your AI agent a true industry expert with deep domain knowledge.

→ **[Browse Context Packs](https://afrexai-cto.github.io/context-packs/)**

**Free tools:** [AI Revenue Calculator](https://afrexai-cto.github.io/ai-revenue-calculator/) | [Agent Setup Wizard](https://afrexai-cto.github.io/agent-setup/)

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) 🖤💛*
