# Home Inspection Business Operations

Run a profitable home inspection business with real numbers, compliance checklists, and growth playbooks.

## What This Covers

### Pricing & Revenue
| Inspection Type | Price Range | Avg Duration | Notes |
|---|---|---|---|
| Standard residential (<2,000 sqft) | $300-$450 | 2-3 hrs | Bread and butter |
| Standard residential (2,000-3,500 sqft) | $400-$600 | 3-4 hrs | Most common |
| Large/luxury (3,500+ sqft) | $550-$900+ | 4-6 hrs | Higher liability |
| New construction (phase) | $350-$500 | 2-3 hrs | Builder pays, repeat work |
| New construction (final) | $400-$550 | 3-4 hrs | Before closing |
| 11-month warranty | $250-$400 | 2-3 hrs | Builder warranty expiring |
| Pre-listing (seller) | $300-$500 | 2-3 hrs | Growing segment |
| Commercial (small) | $800-$2,000 | 4-8 hrs | Higher E&O needed |
| Radon testing | $150-$200 add-on | 48hr monitor | ~40% attachment rate |
| Mold/air quality | $200-$400 add-on | Same visit | ~20% attachment rate |
| Sewer scope | $150-$300 add-on | 30-45 min | ~35% attachment rate |
| Termite/WDI | $75-$150 add-on | Same visit | Required in some states |
| Pool/spa | $150-$250 add-on | 30-45 min | Regional demand |
| Thermal imaging | $100-$200 add-on | Same visit | Differentiator |

**Revenue math:** 4 inspections/week × $475 avg × 50 weeks = $95,000. Add ancillary services at 35% attachment = $128,000. Scale to 2 inspectors = $250K+.

### Licensing & Compliance by State
| Requirement | States Requiring | Details |
|---|---|---|
| State license required | 37 states + DC | Check your state board |
| Pre-licensing education | Most licensed states | 60-200 hours depending on state |
| Continuing education | Most licensed states | 14-40 hours/year or biennial |
| E&O insurance required | ~20 states | $500K-$1M minimum typical |
| Standards of Practice | ASHI, InterNACHI, or state-specific | Must follow one |
| Report delivery timeline | Varies | 24-48 hours typical, some states mandate |

**Key associations:**
- **ASHI** (American Society of Home Inspectors) — gold standard, ~$400/yr
- **InterNACHI** — largest, extensive free training, ~$49/mo
- **State boards** — check your state licensing board requirements first

### Insurance Requirements
| Coverage | Recommended Minimum | Annual Cost |
|---|---|---|
| E&O (Errors & Omissions) | $500,000 | $1,500-$3,000 |
| General liability | $1,000,000 | $800-$1,500 |
| Commercial auto | State minimum + umbrella | $1,200-$2,400 |
| Workers comp (with employees) | State required | $2,000-$4,000/inspector |

**E&O claims reality:** Average claim = $10,000-$30,000. Most common: missed water intrusion, foundation issues, roof defects, electrical hazards. Pre-inspection agreement with liability cap ($fee paid) reduces exposure.

### Equipment Essentials
| Item | Cost | Priority |
|---|---|---|
| Inspection software (Spectora/HomeGauge) | $100-$200/mo | Must-have |
| Thermal imaging camera (FLIR C5 or better) | $500-$3,000 | High ROI differentiator |
| Moisture meter (pin + pinless) | $150-$400 | Essential |
| Gas leak detector | $100-$300 | Safety requirement |
| CO detector | $50-$150 | Safety requirement |
| Electrical tester (outlet/GFCI) | $30-$80 | Essential |
| Ladder (telescoping, 13ft+) | $150-$300 | Daily use |
| Radon monitor (continuous) | $800-$1,500 | Revenue add-on |
| Sewer camera | $2,000-$5,000 | Revenue add-on |
| Drone (Part 107 license needed) | $800-$2,000 | Roof access alternative |

**Startup total:** $5,000-$15,000 depending on ancillary services.

### Report Standards
Every report must include:
1. **Structural** — foundation, framing, floors, walls, ceilings, roof structure
2. **Exterior** — siding, trim, flashing, grading, drainage, driveways, walkways
3. **Roofing** — covering, flashings, skylights, chimneys, drainage
4. **Plumbing** — supply, distribution, fixtures, drains, water heater, fuel storage
5. **Electrical** — service entrance, panels, branch circuits, GFCI/AFCI, smoke/CO detectors
6. **HVAC** — heating, cooling, ductwork, venting, filters
7. **Interior** — walls, ceilings, floors, stairs, railings, doors, windows
8. **Insulation & ventilation** — attic, walls, crawlspace, vapor barriers
9. **Fireplaces** — dampers, firebrick, clearances, gas connections
10. **Garage** — door operation, fire separation, auto-reverse

**Photo standard:** Minimum 100-200 photos per inspection. Every defect photographed. Overview shots of each system.

### Scheduling & Workflow
| Phase | Timing | Action |
|---|---|---|
| Booking | 1-5 days before | Confirm address, access, utilities on, scope of work |
| Pre-inspection | Morning of | Drive route, check weather, charge equipment |
| On-site | 2-4 hours | Systematic walk: exterior → roof → attic → interior by floor → basement/crawl → garage |
| Client walkthrough | Last 30-45 min | Walk buyer through major findings in person |
| Report writing | Same day or next morning | Photos + narrative. Deliver within 24 hours |
| Follow-up | 2-3 days after | Check if client has questions. Ask for review |

### Growth Playbook
| Stage | Revenue | Strategy |
|---|---|---|
| Solo startup | $0-$80K | 200+ real estate agent contacts, Google Business Profile, join local board |
| Solo optimized | $80K-$130K | Ancillary services, raise prices 10%, referral program |
| First hire | $130K-$200K | Train inspector, overflow scheduling, you do commercial |
| Small firm | $200K-$400K | 2-3 inspectors, office manager, branded vehicles |
| Regional | $400K-$1M+ | Multiple markets, franchise model, training academy |

**Agent relationships are everything.** Top 20 agents in your market = 80% of your business. Attend closings. Send handwritten notes. Be fast, thorough, and easy to work with.

### 10 KPIs That Matter
1. Inspections per week (target: 4-6 solo, 15-20 with team)
2. Average fee per inspection (target: $475+)
3. Ancillary attachment rate (target: 35%+)
4. Agent referral rate (target: 60%+ of bookings)
5. Online review score (target: 4.8+ on Google)
6. Report delivery time (target: <24 hours)
7. Callback/complaint rate (target: <2%)
8. E&O claim frequency (target: <1 per 500 inspections)
9. Booking-to-completion rate (target: >90%)
10. Revenue per hour on-site (target: $150+)

### Common Mistakes
1. Underpricing to win volume — race to bottom kills margins
2. Skipping pre-inspection agreements — one lawsuit ends your business
3. Not photographing enough — your report is your legal defense
4. Ignoring agent relationships — they control your pipeline
5. No continuing education beyond minimum — miss code changes, lose credibility
6. Operating without proper insurance — E&O is non-negotiable
7. Same-day verbal opinions without written report — liability trap
8. Not offering ancillary services — leaving 30-40% revenue on table

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI operations packs for service businesses.*

**Get the full AI Context Pack for your industry:** https://afrexai-cto.github.io/context-packs/

**Free AI Revenue Calculator:** https://afrexai-cto.github.io/ai-revenue-calculator/

**Agent Setup Wizard:** https://afrexai-cto.github.io/agent-setup/
