# Gym & Fitness Studio Operations

Run a profitable gym or fitness studio. Covers membership pricing, retention, staffing, equipment lifecycle, class scheduling, and growth.

## Membership Pricing (2026 US Market)

### Monthly Membership Tiers
| Tier | Price Range | What's Included |
|------|------------|-----------------|
| Budget/HVLP | $10-30/mo | Basic floor access, limited hours |
| Mid-Range | $40-80/mo | Full access, group classes, locker |
| Premium | $90-150/mo | All access + PT sessions, sauna, towel service |
| Boutique/Studio | $150-300/mo | Specialized (CrossFit, yoga, Pilates, boxing) |

### Revenue Mix Targets
- Membership dues: 60-70% of revenue
- Personal training: 15-20%
- Retail/supplements: 5-8%
- Classes/workshops: 5-10%
- Other (rentals, tanning, childcare): 3-5%

### Key Metrics
- Revenue per square foot: $30-60/sqft/year (good), $60+/sqft/year (excellent)
- Revenue per member: $55-75/mo average across all spend
- Member acquisition cost: $50-150 (digital), $200-400 (traditional)
- Lifetime value target: 10x acquisition cost minimum

## Member Retention

### Churn Benchmarks
- Industry average: 30-50% annual attrition
- Well-run gym: 20-30% annual
- Best in class: <20% annual
- First 90 days = make or break (50%+ of cancellations happen here)

### Retention Playbook
1. **Onboarding sequence** — Day 1 orientation, Day 3 check-in, Day 7 class invite, Day 14 PT intro, Day 30 progress review
2. **Usage tracking** — Flag members with <4 visits/month. Trigger outreach at 2 weeks no-show.
3. **Community** — Challenges, social events, member spotlights. Members with 2+ gym friends churn 50% less.
4. **Freeze vs cancel** — Always offer freeze ($10-15/mo hold fee) before accepting cancellation.
5. **Annual prepay discount** — 15-20% off locks in commitment. Offer at 6-month mark.
6. **Win-back campaigns** — 60 days post-cancel: "We miss you" offer. 30% conversion rate typical.

## Staffing

### Roles & Compensation (US 2026)
| Role | Hourly/Salary | Notes |
|------|--------------|-------|
| Front desk | $13-17/hr | Part-time, shifts |
| Group fitness instructor | $25-75/class | Independent contractor common |
| Personal trainer (employee) | $18-30/hr + commission | 40-60% session revenue split |
| Personal trainer (independent) | 60-70% session revenue | 1099, bring own clients |
| Gym manager | $45K-65K/yr | Operations, staff scheduling |
| General manager | $55K-85K/yr | P&L responsibility |
| Sales counselor | $15-18/hr + commission | $5-25 per signup bonus |

### Staffing Ratios
- 1 front desk per 150-200 active members per shift
- 1 trainer per 30-40 PT clients
- 1 manager per location
- Cleaning: 1 per 5,000-8,000 sqft per shift

## Equipment & Facility

### Equipment Budget
- Initial buildout: $30-75 per sqft (mid-range), $100+ per sqft (premium)
- Annual maintenance/replacement: 10-15% of equipment value
- Equipment lifecycle: Cardio 7-10 years, strength 10-15 years, flooring 8-12 years
- Lease vs buy: Leasing preserves cash but costs 20-30% more over lifecycle

### Must-Have Equipment Per 10,000 sqft
- Cardio: 15-25 machines (treadmills, bikes, ellipticals, rowers)
- Free weights: Full dumbbell rack (5-100lb), 3-4 bench stations, 2-3 squat racks
- Machines: 10-15 plate-loaded and cable machines
- Functional: Turf area, battle ropes, kettlebells, TRX, plyo boxes
- Stretching: Foam rollers, mats, mobility tools

### Facility Costs
| Item | Monthly Cost |
|------|-------------|
| Rent (suburban) | $8-15/sqft/year |
| Rent (urban) | $15-35/sqft/year |
| Utilities | $1.50-3/sqft/year |
| Insurance (general liability) | $2,000-5,000/year |
| Insurance (professional liability) | $1,000-3,000/year |
| Cleaning supplies | $500-1,500/mo |
| Software (management) | $150-500/mo |

## Class Scheduling

### Optimization Rules
- Peak hours: 5-8 AM, 5-8 PM weekdays. Schedule popular classes here.
- Off-peak incentive: Discounted or free classes 10 AM-3 PM to spread load.
- Class capacity: 70-85% fill rate is ideal. Above 90% = add another time slot.
- Instructor quality drives attendance more than class type. Track per-instructor attendance.
- Saturday AM and Sunday AM are premium — high attendance, use best instructors.

### Popular Class Types (ranked by demand, 2026)
1. HIIT/functional training
2. Yoga (all varieties)
3. Cycling/spin
4. Strength/barbell
5. Pilates (mat and reformer)
6. Boxing/kickboxing
7. Dance fitness
8. Recovery/stretch

## Compliance & Insurance

### Required
- **General liability**: $1M per occurrence / $2M aggregate minimum
- **Professional liability**: Covers trainer negligence claims
- **Workers' comp**: Required in most states for employees
- **Property insurance**: Equipment and facility coverage
- **AED/CPR**: AED on premises, staff CPR certified (required in 20+ states)
- **Waiver/release**: Every member signs liability waiver. State-specific language required.
- **ADA compliance**: Accessible equipment, pathways, restrooms. Non-negotiable.

### Safety Standards
- Equipment inspection: Weekly visual, monthly detailed, annual professional
- Cleaning: Sanitize all touchpoints every 2 hours during operating hours
- Emergency plan: Posted, staff trained quarterly
- Minor policy: State-dependent. Many require 14+ with guardian consent.

## Growth Playbook

### Phase 1: Launch (0-6 months)
- Pre-sale campaign 60-90 days before opening. Target: 200-400 founding members.
- Founding member discount (20-30% locked rate) creates urgency.
- Local partnerships: corporate wellness programs, physical therapy referrals, sports teams.
- Google Business Profile optimized. 50+ reviews within 90 days.

### Phase 2: Stabilize (6-18 months)
- Break-even target: 60-70% of capacity membership
- Focus shifts from acquisition to retention
- Launch personal training program (highest margin revenue)
- Introduce annual membership push (cash flow + commitment)
- Referral program: $25-50 credit per referred member who joins

### Phase 3: Optimize (18-36 months)
- Secondary revenue streams: retail, supplements, branded merchandise
- Corporate packages: 10+ employee group rates
- Kids programs / childcare (differentiator, drives parent memberships)
- Technology: app-based booking, keycard 24/7 access, body scanning

### Phase 4: Scale (36+ months)
- Second location feasibility at 85%+ capacity sustained 6 months
- Franchise model vs company-owned analysis
- Digital offerings: online classes, training programs, app subscriptions
- Acquisition targets: struggling competitor gyms at equipment value

## Financial Benchmarks

### Healthy P&L (% of revenue)
| Category | Target % |
|----------|---------|
| Rent/occupancy | 15-25% |
| Payroll (all staff) | 35-44% |
| Equipment lease/depreciation | 5-10% |
| Marketing | 5-10% |
| Utilities | 3-6% |
| Insurance | 2-4% |
| Software/tech | 1-3% |
| Supplies/maintenance | 2-4% |
| **Net profit margin** | **10-20%** |

### Break-Even Formula
Monthly fixed costs ÷ Average revenue per member = Members needed to break even

Example: $30,000 fixed costs ÷ $60 avg revenue/member = 500 members to break even

---

*Built by [AfrexAI](https://afrexai-cto.github.io/context-packs/) — AI-powered business operations context for agents that actually work.*
